/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.time.Instant;
import java.util.Iterator;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import me.tongfei.progressbar.ProgressState;
import me.tongfei.progressbar.ProgressThread;
import me.tongfei.progressbar.Util;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedInputStream;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedIterable;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedIterator;

public class ProgressBar
implements AutoCloseable {
    private ProgressState progress;
    private ProgressThread target;
    private Thread thread;

    public ProgressBar(String string, long l) {
        this(string, l, 1000, System.err, ProgressBarStyle.COLORFUL_UNICODE_BLOCK, "", 1L);
    }

    public ProgressBar(String string, long l, ProgressBarStyle progressBarStyle) {
        this(string, l, 1000, System.err, progressBarStyle, "", 1L);
    }

    public ProgressBar(String string, long l, int n) {
        this(string, l, n, System.err, ProgressBarStyle.COLORFUL_UNICODE_BLOCK, "", 1L);
    }

    public ProgressBar(String string, long l, int n, PrintStream printStream, ProgressBarStyle progressBarStyle, String string2, long l2) {
        this.progress = new ProgressState(string, l);
        this.target = new ProgressThread(this.progress, progressBarStyle, n, printStream, string2, l2);
        this.thread = new Thread((Runnable)this.target, this.getClass().getName());
        this.progress.startTime = Instant.now();
        this.thread.start();
    }

    @Deprecated
    public ProgressBar start() {
        this.progress.startTime = Instant.now();
        this.thread.start();
        return this;
    }

    public ProgressBar stepBy(long l) {
        this.progress.stepBy(l);
        return this;
    }

    public ProgressBar stepTo(long l) {
        this.progress.stepTo(l);
        return this;
    }

    public ProgressBar step() {
        this.progress.stepBy(1L);
        return this;
    }

    public ProgressBar maxHint(long l) {
        if (l < 0L) {
            this.progress.setAsIndefinite();
        } else {
            this.progress.setAsDefinite();
            this.progress.maxHint(l);
        }
        return this;
    }

    @Deprecated
    public ProgressBar stop() {
        this.close();
        return this;
    }

    @Override
    public void close() {
        this.target.kill();
        try {
            this.thread.join();
            this.target.consoleStream.print("\n");
            this.target.consoleStream.flush();
            this.target.terminal.close();
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
    }

    public ProgressBar setExtraMessage(String string) {
        this.progress.setExtraMessage(string);
        return this;
    }

    public long getCurrent() {
        return this.progress.getCurrent();
    }

    public long getMax() {
        return this.progress.getMax();
    }

    public String getTask() {
        return this.progress.getTask();
    }

    public String getExtraMessage() {
        return this.progress.getExtraMessage();
    }

    public static <T> Iterator<T> wrap(Iterator<T> iterator, String string) {
        return ProgressBar.wrap(iterator, new ProgressBarBuilder().setTaskName(string).setInitialMax(-1L));
    }

    public static <T> Iterator<T> wrap(Iterator<T> iterator, ProgressBarBuilder progressBarBuilder) {
        return new ProgressBarWrappedIterator<T>(iterator, progressBarBuilder.build());
    }

    public static <T> Iterable<T> wrap(Iterable<T> iterable, String string) {
        return ProgressBar.wrap(iterable, new ProgressBarBuilder().setTaskName(string));
    }

    public static <T> Iterable<T> wrap(Iterable<T> iterable, ProgressBarBuilder progressBarBuilder) {
        return new ProgressBarWrappedIterable<T>(iterable, progressBarBuilder);
    }

    public static InputStream wrap(InputStream inputStream, String string) {
        ProgressBarBuilder progressBarBuilder = new ProgressBarBuilder().setTaskName(string).setInitialMax(Util.getInputStreamSize(inputStream));
        return ProgressBar.wrap(inputStream, progressBarBuilder);
    }

    public static InputStream wrap(InputStream inputStream, ProgressBarBuilder progressBarBuilder) {
        return new ProgressBarWrappedInputStream(inputStream, progressBarBuilder.setInitialMax(Util.getInputStreamSize(inputStream)).build());
    }
}

