/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.stackmap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.stackmap.TypeTag;

public abstract class TypeData {
    public static TypeData[] make(int n) {
        TypeData[] typeDataArray = new TypeData[n];
        for (int i = 0; i < n; ++i) {
            typeDataArray[i] = TypeTag.TOP;
        }
        return typeDataArray;
    }

    protected TypeData() {
    }

    private static void setType(TypeData typeData, String string, ClassPool classPool) {
        typeData.setType(string, classPool);
    }

    public abstract int getTypeTag();

    public abstract int getTypeData(ConstPool var1);

    public TypeData join() {
        return new TypeVar(this);
    }

    public abstract BasicType isBasicType();

    public abstract boolean is2WordType();

    public boolean isNullType() {
        return false;
    }

    public boolean isUninit() {
        return false;
    }

    public abstract boolean eq(TypeData var1);

    public abstract String getName();

    public abstract void setType(String var1, ClassPool var2);

    public abstract TypeData getArrayType(int var1);

    public int dfs(ArrayList arrayList, int n, ClassPool classPool) {
        return n;
    }

    protected TypeVar toTypeVar(int n) {
        return null;
    }

    public void constructorCalled(int n) {
    }

    public String toString() {
        return super.toString() + "(" + this.toString2(new HashSet()) + ")";
    }

    abstract String toString2(HashSet var1);

    public static CtClass commonSuperClassEx(CtClass ctClass, CtClass ctClass2) {
        if (ctClass == ctClass2) {
            return ctClass;
        }
        if (ctClass.isArray() && ctClass2.isArray()) {
            CtClass ctClass3;
            CtClass ctClass4 = ctClass.getComponentType();
            CtClass ctClass5 = TypeData.commonSuperClassEx(ctClass4, ctClass3 = ctClass2.getComponentType());
            if (ctClass5 == ctClass4) {
                return ctClass;
            }
            if (ctClass5 == ctClass3) {
                return ctClass2;
            }
            return ctClass.getClassPool().get(ctClass5 == null ? "java.lang.Object" : ctClass5.getName() + "[]");
        }
        if (ctClass.isPrimitive() || ctClass2.isPrimitive()) {
            return null;
        }
        if (ctClass.isArray() || ctClass2.isArray()) {
            return ctClass.getClassPool().get("java.lang.Object");
        }
        return TypeData.commonSuperClass(ctClass, ctClass2);
    }

    public static CtClass commonSuperClass(CtClass ctClass, CtClass ctClass2) {
        CtClass ctClass3;
        CtClass ctClass4 = ctClass;
        CtClass ctClass5 = ctClass3 = ctClass2;
        CtClass ctClass6 = ctClass4;
        while (true) {
            if (TypeData.eq(ctClass4, ctClass3) && ctClass4.getSuperclass() != null) {
                return ctClass4;
            }
            CtClass ctClass7 = ctClass4.getSuperclass();
            CtClass ctClass8 = ctClass3.getSuperclass();
            if (ctClass8 == null) {
                ctClass3 = ctClass5;
                break;
            }
            if (ctClass7 == null) {
                ctClass4 = ctClass6;
                ctClass6 = ctClass5;
                ctClass5 = ctClass4;
                ctClass4 = ctClass3;
                ctClass3 = ctClass5;
                break;
            }
            ctClass4 = ctClass7;
            ctClass3 = ctClass8;
        }
        while ((ctClass4 = ctClass4.getSuperclass()) != null) {
            ctClass6 = ctClass6.getSuperclass();
        }
        ctClass4 = ctClass6;
        while (!TypeData.eq(ctClass4, ctClass3)) {
            ctClass4 = ctClass4.getSuperclass();
            ctClass3 = ctClass3.getSuperclass();
        }
        return ctClass4;
    }

    static boolean eq(CtClass ctClass, CtClass ctClass2) {
        return ctClass == ctClass2 || ctClass != null && ctClass2 != null && ctClass.getName().equals(ctClass2.getName());
    }

    public static void aastore(TypeData typeData, TypeData typeData2, ClassPool classPool) {
        if (typeData instanceof AbsTypeVar && !typeData2.isNullType()) {
            ((AbsTypeVar)typeData).merge(ArrayType.make(typeData2));
        }
        if (typeData2 instanceof AbsTypeVar) {
            if (typeData instanceof AbsTypeVar) {
                ArrayElement.make(typeData);
            } else if (typeData instanceof ClassName) {
                if (!typeData.isNullType()) {
                    String string = ArrayElement.typeName(typeData.getName());
                    typeData2.setType(string, classPool);
                }
            } else {
                throw new BadBytecode("bad AASTORE: " + typeData);
            }
        }
    }

    public static class UninitThis
    extends UninitData {
        UninitThis(String string) {
            super(-1, string);
        }

        @Override
        public UninitData copy() {
            return new UninitThis(this.getName());
        }

        @Override
        public int getTypeTag() {
            return 6;
        }

        @Override
        public int getTypeData(ConstPool constPool) {
            return 0;
        }

        @Override
        String toString2(HashSet hashSet) {
            return "uninit:this";
        }
    }

    public static class UninitData
    extends ClassName {
        int offset;
        boolean initialized;

        UninitData(int n, String string) {
            super(string);
            this.offset = n;
            this.initialized = false;
        }

        public UninitData copy() {
            return new UninitData(this.offset, this.getName());
        }

        @Override
        public int getTypeTag() {
            return 8;
        }

        @Override
        public int getTypeData(ConstPool constPool) {
            return this.offset;
        }

        @Override
        public TypeData join() {
            if (this.initialized) {
                return new TypeVar(new ClassName(this.getName()));
            }
            return new UninitTypeVar(this.copy());
        }

        @Override
        public boolean isUninit() {
            return true;
        }

        @Override
        public boolean eq(TypeData typeData) {
            if (typeData instanceof UninitData) {
                UninitData uninitData = (UninitData)typeData;
                return this.offset == uninitData.offset && this.getName().equals(uninitData.getName());
            }
            return false;
        }

        public int offset() {
            return this.offset;
        }

        @Override
        public void constructorCalled(int n) {
            if (n == this.offset) {
                this.initialized = true;
            }
        }

        @Override
        String toString2(HashSet hashSet) {
            return this.getName() + "," + this.offset;
        }
    }

    public static class NullType
    extends ClassName {
        public NullType() {
            super("null-type");
        }

        @Override
        public int getTypeTag() {
            return 5;
        }

        @Override
        public boolean isNullType() {
            return true;
        }

        @Override
        public int getTypeData(ConstPool constPool) {
            return 0;
        }

        @Override
        public TypeData getArrayType(int n) {
            return this;
        }
    }

    public static class ClassName
    extends TypeData {
        private String name;

        public ClassName(String string) {
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public BasicType isBasicType() {
            return null;
        }

        @Override
        public boolean is2WordType() {
            return false;
        }

        @Override
        public int getTypeTag() {
            return 7;
        }

        @Override
        public int getTypeData(ConstPool constPool) {
            return constPool.addClassInfo(this.getName());
        }

        @Override
        public boolean eq(TypeData typeData) {
            return this.name.equals(typeData.getName());
        }

        @Override
        public void setType(String string, ClassPool classPool) {
        }

        @Override
        public TypeData getArrayType(int n) {
            int n2;
            if (n == 0) {
                return this;
            }
            if (n > 0) {
                char[] cArray = new char[n];
                for (int i = 0; i < n; ++i) {
                    cArray[i] = 91;
                }
                String string = this.getName();
                if (string.charAt(0) != '[') {
                    string = "L" + string.replace('.', '/') + ";";
                }
                return new ClassName(new String(cArray) + string);
            }
            for (n2 = 0; n2 < -n; ++n2) {
                if (this.name.charAt(n2) == '[') continue;
                throw new NotFoundException("no " + n + " dimensional array type: " + this.getName());
            }
            n2 = this.name.charAt(-n);
            if (n2 == 91) {
                return new ClassName(this.name.substring(-n));
            }
            if (n2 == 76) {
                return new ClassName(this.name.substring(-n + 1, this.name.length() - 1).replace('/', '.'));
            }
            if (n2 == TypeTag.DOUBLE.decodedName) {
                return TypeTag.DOUBLE;
            }
            if (n2 == TypeTag.FLOAT.decodedName) {
                return TypeTag.FLOAT;
            }
            if (n2 == TypeTag.LONG.decodedName) {
                return TypeTag.LONG;
            }
            return TypeTag.INTEGER;
        }

        @Override
        String toString2(HashSet hashSet) {
            return this.name;
        }
    }

    public static class UninitTypeVar
    extends AbsTypeVar {
        protected TypeData type;

        public UninitTypeVar(UninitData uninitData) {
            this.type = uninitData;
        }

        @Override
        public int getTypeTag() {
            return this.type.getTypeTag();
        }

        @Override
        public int getTypeData(ConstPool constPool) {
            return this.type.getTypeData(constPool);
        }

        @Override
        public BasicType isBasicType() {
            return this.type.isBasicType();
        }

        @Override
        public boolean is2WordType() {
            return this.type.is2WordType();
        }

        @Override
        public boolean isUninit() {
            return this.type.isUninit();
        }

        @Override
        public boolean eq(TypeData typeData) {
            return this.type.eq(typeData);
        }

        @Override
        public String getName() {
            return this.type.getName();
        }

        @Override
        protected TypeVar toTypeVar(int n) {
            return null;
        }

        @Override
        public TypeData join() {
            return this.type.join();
        }

        @Override
        public void setType(String string, ClassPool classPool) {
            this.type.setType(string, classPool);
        }

        @Override
        public void merge(TypeData typeData) {
            if (!typeData.eq(this.type)) {
                this.type = TypeTag.TOP;
            }
        }

        @Override
        public void constructorCalled(int n) {
            this.type.constructorCalled(n);
        }

        public int offset() {
            if (this.type instanceof UninitData) {
                return ((UninitData)this.type).offset;
            }
            throw new RuntimeException("not available");
        }

        @Override
        public TypeData getArrayType(int n) {
            return this.type.getArrayType(n);
        }

        @Override
        String toString2(HashSet hashSet) {
            return "";
        }
    }

    public static class ArrayElement
    extends AbsTypeVar {
        private AbsTypeVar array;

        private ArrayElement(AbsTypeVar absTypeVar) {
            this.array = absTypeVar;
        }

        public static TypeData make(TypeData typeData) {
            if (typeData instanceof ArrayType) {
                return ((ArrayType)typeData).elementType();
            }
            if (typeData instanceof AbsTypeVar) {
                return new ArrayElement((AbsTypeVar)typeData);
            }
            if (typeData instanceof ClassName && !typeData.isNullType()) {
                return new ClassName(ArrayElement.typeName(typeData.getName()));
            }
            throw new BadBytecode("bad AASTORE: " + typeData);
        }

        @Override
        public void merge(TypeData typeData) {
            try {
                if (!typeData.isNullType()) {
                    this.array.merge(ArrayType.make(typeData));
                }
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException("fatal: " + badBytecode);
            }
        }

        @Override
        public String getName() {
            return ArrayElement.typeName(this.array.getName());
        }

        public AbsTypeVar arrayType() {
            return this.array;
        }

        @Override
        public BasicType isBasicType() {
            return null;
        }

        @Override
        public boolean is2WordType() {
            return false;
        }

        private static String typeName(String string) {
            if (string.length() > 1 && string.charAt(0) == '[') {
                char c = string.charAt(1);
                if (c == 'L') {
                    return string.substring(2, string.length() - 1).replace('/', '.');
                }
                if (c == '[') {
                    return string.substring(1);
                }
            }
            return "java.lang.Object";
        }

        @Override
        public void setType(String string, ClassPool classPool) {
            this.array.setType(ArrayType.typeName(string), classPool);
        }

        @Override
        protected TypeVar toTypeVar(int n) {
            return this.array.toTypeVar(n - 1);
        }

        @Override
        public TypeData getArrayType(int n) {
            return this.array.getArrayType(n - 1);
        }

        @Override
        public int dfs(ArrayList arrayList, int n, ClassPool classPool) {
            return this.array.dfs(arrayList, n, classPool);
        }

        @Override
        String toString2(HashSet hashSet) {
            return "*" + this.array.toString2(hashSet);
        }
    }

    public static class ArrayType
    extends AbsTypeVar {
        private AbsTypeVar element;

        private ArrayType(AbsTypeVar absTypeVar) {
            this.element = absTypeVar;
        }

        static TypeData make(TypeData typeData) {
            if (typeData instanceof ArrayElement) {
                return ((ArrayElement)typeData).arrayType();
            }
            if (typeData instanceof AbsTypeVar) {
                return new ArrayType((AbsTypeVar)typeData);
            }
            if (typeData instanceof ClassName && !typeData.isNullType()) {
                return new ClassName(ArrayType.typeName(typeData.getName()));
            }
            throw new BadBytecode("bad AASTORE: " + typeData);
        }

        @Override
        public void merge(TypeData typeData) {
            try {
                if (!typeData.isNullType()) {
                    this.element.merge(ArrayElement.make(typeData));
                }
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException("fatal: " + badBytecode);
            }
        }

        @Override
        public String getName() {
            return ArrayType.typeName(this.element.getName());
        }

        public AbsTypeVar elementType() {
            return this.element;
        }

        @Override
        public BasicType isBasicType() {
            return null;
        }

        @Override
        public boolean is2WordType() {
            return false;
        }

        public static String typeName(String string) {
            if (string.charAt(0) == '[') {
                return "[" + string;
            }
            return "[L" + string.replace('.', '/') + ";";
        }

        @Override
        public void setType(String string, ClassPool classPool) {
            this.element.setType(ArrayElement.typeName(string), classPool);
        }

        @Override
        protected TypeVar toTypeVar(int n) {
            return this.element.toTypeVar(n + 1);
        }

        @Override
        public TypeData getArrayType(int n) {
            return this.element.getArrayType(n + 1);
        }

        @Override
        public int dfs(ArrayList arrayList, int n, ClassPool classPool) {
            return this.element.dfs(arrayList, n, classPool);
        }

        @Override
        String toString2(HashSet hashSet) {
            return "[" + this.element.toString2(hashSet);
        }
    }

    public static class TypeVar
    extends AbsTypeVar {
        protected ArrayList lowers = new ArrayList(2);
        protected ArrayList usedBy = new ArrayList(2);
        protected ArrayList uppers = null;
        protected String fixedType;
        private boolean is2WordType;
        private int visited = 0;
        private int smallest = 0;
        private boolean inList = false;
        private int dimension = 0;

        public TypeVar(TypeData typeData) {
            this.merge(typeData);
            this.fixedType = null;
            this.is2WordType = typeData.is2WordType();
        }

        @Override
        public String getName() {
            if (this.fixedType == null) {
                return ((TypeData)this.lowers.get(0)).getName();
            }
            return this.fixedType;
        }

        @Override
        public BasicType isBasicType() {
            if (this.fixedType == null) {
                return ((TypeData)this.lowers.get(0)).isBasicType();
            }
            return null;
        }

        @Override
        public boolean is2WordType() {
            if (this.fixedType == null) {
                return this.is2WordType;
            }
            return false;
        }

        @Override
        public boolean isNullType() {
            if (this.fixedType == null) {
                return ((TypeData)this.lowers.get(0)).isNullType();
            }
            return false;
        }

        @Override
        public boolean isUninit() {
            if (this.fixedType == null) {
                return ((TypeData)this.lowers.get(0)).isUninit();
            }
            return false;
        }

        @Override
        public void merge(TypeData typeData) {
            this.lowers.add(typeData);
            if (typeData instanceof TypeVar) {
                ((TypeVar)typeData).usedBy.add(this);
            }
        }

        @Override
        public int getTypeTag() {
            if (this.fixedType == null) {
                return ((TypeData)this.lowers.get(0)).getTypeTag();
            }
            return super.getTypeTag();
        }

        @Override
        public int getTypeData(ConstPool constPool) {
            if (this.fixedType == null) {
                return ((TypeData)this.lowers.get(0)).getTypeData(constPool);
            }
            return super.getTypeData(constPool);
        }

        @Override
        public void setType(String string, ClassPool classPool) {
            if (this.uppers == null) {
                this.uppers = new ArrayList();
            }
            this.uppers.add(string);
        }

        @Override
        protected TypeVar toTypeVar(int n) {
            this.dimension = n;
            return this;
        }

        @Override
        public TypeData getArrayType(int n) {
            if (n == 0) {
                return this;
            }
            BasicType basicType = this.isBasicType();
            if (basicType == null) {
                if (this.isNullType()) {
                    return new NullType();
                }
                return new ClassName(this.getName()).getArrayType(n);
            }
            return basicType.getArrayType(n);
        }

        @Override
        public int dfs(ArrayList arrayList, int n, ClassPool classPool) {
            TypeVar typeVar;
            if (this.visited > 0) {
                return n;
            }
            this.visited = this.smallest = ++n;
            arrayList.add(this);
            this.inList = true;
            int n2 = this.lowers.size();
            for (int i = 0; i < n2; ++i) {
                typeVar = ((TypeData)this.lowers.get(i)).toTypeVar(this.dimension);
                if (typeVar == null) continue;
                if (typeVar.visited == 0) {
                    n = typeVar.dfs(arrayList, n, classPool);
                    if (typeVar.smallest >= this.smallest) continue;
                    this.smallest = typeVar.smallest;
                    continue;
                }
                if (!typeVar.inList || typeVar.visited >= this.smallest) continue;
                this.smallest = typeVar.visited;
            }
            if (this.visited == this.smallest) {
                ArrayList<TypeVar> arrayList2 = new ArrayList<TypeVar>();
                do {
                    typeVar = (TypeVar)arrayList.remove(arrayList.size() - 1);
                    typeVar.inList = false;
                    arrayList2.add(typeVar);
                } while (typeVar != this);
                this.fixTypes(arrayList2, classPool);
            }
            return n;
        }

        private void fixTypes(ArrayList arrayList, ClassPool classPool) {
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl = false;
            TypeData typeData = null;
            int n = arrayList.size();
            block0: for (int i = 0; i < n; ++i) {
                TypeVar typeVar = (TypeVar)arrayList.get(i);
                ArrayList arrayList2 = typeVar.lowers;
                int n2 = arrayList2.size();
                for (int j = 0; j < n2; ++j) {
                    TypeData typeData2 = (TypeData)arrayList2.get(j);
                    TypeData typeData3 = typeData2.getArrayType(typeVar.dimension);
                    BasicType basicType = typeData3.isBasicType();
                    if (typeData == null) {
                        if (basicType == null) {
                            bl = false;
                            typeData = typeData3;
                            if (typeData3.isUninit()) {
                                continue block0;
                            }
                        } else {
                            bl = true;
                            typeData = basicType;
                        }
                    } else if (basicType == null && bl || basicType != null && typeData != basicType) {
                        bl = true;
                        typeData = TypeTag.TOP;
                        continue block0;
                    }
                    if (basicType != null || typeData3.isNullType()) continue;
                    hashSet.add(typeData3.getName());
                }
            }
            if (bl) {
                this.is2WordType = typeData.is2WordType();
                this.fixTypes1(arrayList, typeData);
            } else {
                String string = this.fixTypes2(arrayList, hashSet, classPool);
                this.fixTypes1(arrayList, new ClassName(string));
            }
        }

        private void fixTypes1(ArrayList arrayList, TypeData typeData) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                TypeVar typeVar = (TypeVar)arrayList.get(i);
                TypeData typeData2 = typeData.getArrayType(-typeVar.dimension);
                if (typeData2.isBasicType() == null) {
                    typeVar.fixedType = typeData2.getName();
                    continue;
                }
                typeVar.lowers.clear();
                typeVar.lowers.add(typeData2);
                typeVar.is2WordType = typeData2.is2WordType();
            }
        }

        private String fixTypes2(ArrayList arrayList, HashSet hashSet, ClassPool classPool) {
            Iterator iterator = hashSet.iterator();
            if (hashSet.size() == 0) {
                return null;
            }
            if (hashSet.size() == 1) {
                return (String)iterator.next();
            }
            CtClass ctClass = classPool.get((String)iterator.next());
            while (iterator.hasNext()) {
                ctClass = TypeVar.commonSuperClassEx(ctClass, classPool.get((String)iterator.next()));
            }
            if (ctClass.getSuperclass() == null || TypeVar.isObjectArray(ctClass)) {
                ctClass = this.fixByUppers(arrayList, classPool, new HashSet(), ctClass);
            }
            if (ctClass.isArray()) {
                return Descriptor.toJvmName(ctClass);
            }
            return ctClass.getName();
        }

        private static boolean isObjectArray(CtClass ctClass) {
            return ctClass.isArray() && ctClass.getComponentType().getSuperclass() == null;
        }

        private CtClass fixByUppers(ArrayList arrayList, ClassPool classPool, HashSet hashSet, CtClass ctClass) {
            if (arrayList == null) {
                return ctClass;
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                TypeVar typeVar = (TypeVar)arrayList.get(i);
                if (!hashSet.add(typeVar)) {
                    return ctClass;
                }
                if (typeVar.uppers != null) {
                    int n2 = typeVar.uppers.size();
                    for (int j = 0; j < n2; ++j) {
                        CtClass ctClass2 = classPool.get((String)typeVar.uppers.get(j));
                        if (!ctClass2.subtypeOf(ctClass)) continue;
                        ctClass = ctClass2;
                    }
                }
                ctClass = this.fixByUppers(typeVar.usedBy, classPool, hashSet, ctClass);
            }
            return ctClass;
        }

        @Override
        String toString2(HashSet hashSet) {
            TypeData typeData;
            hashSet.add(this);
            if (this.lowers.size() > 0 && (typeData = (TypeData)this.lowers.get(0)) != null && !hashSet.contains(typeData)) {
                return typeData.toString2(hashSet);
            }
            return "?";
        }
    }

    public static abstract class AbsTypeVar
    extends TypeData {
        public abstract void merge(TypeData var1);

        @Override
        public int getTypeTag() {
            return 7;
        }

        @Override
        public int getTypeData(ConstPool constPool) {
            return constPool.addClassInfo(this.getName());
        }

        @Override
        public boolean eq(TypeData typeData) {
            return this.getName().equals(typeData.getName());
        }
    }

    protected static class BasicType
    extends TypeData {
        private String name;
        private int typeTag;
        private char decodedName;

        public BasicType(String string, int n, char c) {
            this.name = string;
            this.typeTag = n;
            this.decodedName = c;
        }

        @Override
        public int getTypeTag() {
            return this.typeTag;
        }

        @Override
        public int getTypeData(ConstPool constPool) {
            return 0;
        }

        @Override
        public TypeData join() {
            if (this == TypeTag.TOP) {
                return this;
            }
            return super.join();
        }

        @Override
        public BasicType isBasicType() {
            return this;
        }

        @Override
        public boolean is2WordType() {
            return this.typeTag == 4 || this.typeTag == 3;
        }

        @Override
        public boolean eq(TypeData typeData) {
            return this == typeData;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public char getDecodedName() {
            return this.decodedName;
        }

        @Override
        public void setType(String string, ClassPool classPool) {
            throw new BadBytecode("conflict: " + this.name + " and " + string);
        }

        @Override
        public TypeData getArrayType(int n) {
            if (this == TypeTag.TOP) {
                return this;
            }
            if (n < 0) {
                throw new NotFoundException("no element type: " + this.name);
            }
            if (n == 0) {
                return this;
            }
            char[] cArray = new char[n + 1];
            for (int i = 0; i < n; ++i) {
                cArray[i] = 91;
            }
            cArray[n] = this.decodedName;
            return new ClassName(new String(cArray));
        }

        @Override
        String toString2(HashSet hashSet) {
            return this.name;
        }
    }
}

