/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.annotation;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.annotation.AnnotationImpl;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.AnnotationsWriter;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class Annotation {
    ConstPool pool;
    int typeIndex;
    LinkedHashMap members;

    public Annotation(int n, ConstPool constPool) {
        this.pool = constPool;
        this.typeIndex = n;
        this.members = null;
    }

    public Annotation(String string, ConstPool constPool) {
        this(constPool.addUtf8Info(Descriptor.of(string)), constPool);
    }

    public Annotation(ConstPool constPool, CtClass ctClass) {
        this(constPool.addUtf8Info(Descriptor.of(ctClass.getName())), constPool);
        if (!ctClass.isInterface()) {
            throw new RuntimeException("Only interfaces are allowed for Annotation creation.");
        }
        CtMethod[] ctMethodArray = ctClass.getDeclaredMethods();
        if (ctMethodArray.length > 0) {
            this.members = new LinkedHashMap();
        }
        for (int i = 0; i < ctMethodArray.length; ++i) {
            CtClass ctClass2 = ctMethodArray[i].getReturnType();
            this.addMemberValue(ctMethodArray[i].getName(), Annotation.createMemberValue(constPool, ctClass2));
        }
    }

    public static MemberValue createMemberValue(ConstPool constPool, CtClass ctClass) {
        if (ctClass == CtClass.booleanType) {
            return new BooleanMemberValue(constPool);
        }
        if (ctClass == CtClass.byteType) {
            return new ByteMemberValue(constPool);
        }
        if (ctClass == CtClass.charType) {
            return new CharMemberValue(constPool);
        }
        if (ctClass == CtClass.shortType) {
            return new ShortMemberValue(constPool);
        }
        if (ctClass == CtClass.intType) {
            return new IntegerMemberValue(constPool);
        }
        if (ctClass == CtClass.longType) {
            return new LongMemberValue(constPool);
        }
        if (ctClass == CtClass.floatType) {
            return new FloatMemberValue(constPool);
        }
        if (ctClass == CtClass.doubleType) {
            return new DoubleMemberValue(constPool);
        }
        if (ctClass.getName().equals("java.lang.Class")) {
            return new ClassMemberValue(constPool);
        }
        if (ctClass.getName().equals("java.lang.String")) {
            return new StringMemberValue(constPool);
        }
        if (ctClass.isArray()) {
            CtClass ctClass2 = ctClass.getComponentType();
            MemberValue memberValue = Annotation.createMemberValue(constPool, ctClass2);
            return new ArrayMemberValue(memberValue, constPool);
        }
        if (ctClass.isInterface()) {
            Annotation annotation = new Annotation(constPool, ctClass);
            return new AnnotationMemberValue(annotation, constPool);
        }
        EnumMemberValue enumMemberValue = new EnumMemberValue(constPool);
        enumMemberValue.setType(ctClass.getName());
        return enumMemberValue;
    }

    public void addMemberValue(int n, MemberValue memberValue) {
        Pair pair = new Pair();
        pair.name = n;
        pair.value = memberValue;
        this.addMemberValue(pair);
    }

    public void addMemberValue(String string, MemberValue memberValue) {
        Pair pair = new Pair();
        pair.name = this.pool.addUtf8Info(string);
        pair.value = memberValue;
        if (this.members == null) {
            this.members = new LinkedHashMap();
        }
        this.members.put(string, pair);
    }

    private void addMemberValue(Pair pair) {
        String string = this.pool.getUtf8Info(pair.name);
        if (this.members == null) {
            this.members = new LinkedHashMap();
        }
        this.members.put(string, pair);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("@");
        stringBuffer.append(this.getTypeName());
        if (this.members != null) {
            stringBuffer.append("(");
            Iterator iterator = this.members.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string).append("=").append(this.getMemberValue(string));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String getTypeName() {
        return Descriptor.toClassName(this.pool.getUtf8Info(this.typeIndex));
    }

    public Set getMemberNames() {
        if (this.members == null) {
            return null;
        }
        return this.members.keySet();
    }

    public MemberValue getMemberValue(String string) {
        if (this.members == null) {
            return null;
        }
        Pair pair = (Pair)this.members.get(string);
        if (pair == null) {
            return null;
        }
        return pair.value;
    }

    public Object toAnnotationType(ClassLoader classLoader, ClassPool classPool) {
        return AnnotationImpl.make(classLoader, MemberValue.loadClass(classLoader, this.getTypeName()), classPool, this);
    }

    public void write(AnnotationsWriter annotationsWriter) {
        String string = this.pool.getUtf8Info(this.typeIndex);
        if (this.members == null) {
            annotationsWriter.annotation(string, 0);
            return;
        }
        annotationsWriter.annotation(string, this.members.size());
        for (Pair pair : this.members.values()) {
            annotationsWriter.memberValuePair(pair.name);
            pair.value.write(annotationsWriter);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Annotation)) {
            return false;
        }
        Annotation annotation = (Annotation)object;
        if (!this.getTypeName().equals(annotation.getTypeName())) {
            return false;
        }
        LinkedHashMap linkedHashMap = annotation.members;
        if (this.members == linkedHashMap) {
            return true;
        }
        if (this.members == null) {
            return linkedHashMap == null;
        }
        if (linkedHashMap == null) {
            return false;
        }
        return this.members.equals(linkedHashMap);
    }

    static class Pair {
        int name;
        MemberValue value;

        Pair() {
        }
    }
}

