/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.analysis;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javassist.CtClass;
import javassist.bytecode.analysis.Type;

public class MultiType
extends Type {
    private Map interfaces;
    private Type resolved;
    private Type potentialClass;
    private MultiType mergeSource;
    private boolean changed = false;

    public MultiType(Map map) {
        this(map, null);
    }

    public MultiType(Map map, Type type) {
        super(null);
        this.interfaces = map;
        this.potentialClass = type;
    }

    @Override
    public CtClass getCtClass() {
        if (this.resolved != null) {
            return this.resolved.getCtClass();
        }
        return Type.OBJECT.getCtClass();
    }

    @Override
    public Type getComponent() {
        return null;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    boolean popChanged() {
        boolean bl = this.changed;
        this.changed = false;
        return bl;
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isAssignableTo(Type type) {
        Map map;
        if (this.resolved != null) {
            return type.isAssignableFrom(this.resolved);
        }
        if (Type.OBJECT.equals(type)) {
            return true;
        }
        if (this.potentialClass != null && !type.isAssignableFrom(this.potentialClass)) {
            this.potentialClass = null;
        }
        if ((map = this.mergeMultiAndSingle(this, type)).size() == 1 && this.potentialClass == null) {
            this.resolved = Type.get((CtClass)map.values().iterator().next());
            this.propogateResolved();
            return true;
        }
        if (map.size() >= 1) {
            this.interfaces = map;
            this.propogateState();
            return true;
        }
        if (this.potentialClass != null) {
            this.resolved = this.potentialClass;
            this.propogateResolved();
            return true;
        }
        return false;
    }

    private void propogateState() {
        MultiType multiType = this.mergeSource;
        while (multiType != null) {
            multiType.interfaces = this.interfaces;
            multiType.potentialClass = this.potentialClass;
            multiType = multiType.mergeSource;
        }
    }

    private void propogateResolved() {
        MultiType multiType = this.mergeSource;
        while (multiType != null) {
            multiType.resolved = this.resolved;
            multiType = multiType.mergeSource;
        }
    }

    @Override
    public boolean isReference() {
        return true;
    }

    private Map getAllMultiInterfaces(MultiType multiType) {
        HashMap<String, CtClass> hashMap = new HashMap<String, CtClass>();
        for (CtClass ctClass : multiType.interfaces.values()) {
            hashMap.put(ctClass.getName(), ctClass);
            this.getAllInterfaces(ctClass, hashMap);
        }
        return hashMap;
    }

    private Map mergeMultiInterfaces(MultiType multiType, MultiType multiType2) {
        Map map = this.getAllMultiInterfaces(multiType);
        Map map2 = this.getAllMultiInterfaces(multiType2);
        return this.findCommonInterfaces(map, map2);
    }

    private Map mergeMultiAndSingle(MultiType multiType, Type type) {
        Map map = this.getAllMultiInterfaces(multiType);
        Map map2 = this.getAllInterfaces(type.getCtClass(), null);
        return this.findCommonInterfaces(map, map2);
    }

    private boolean inMergeSource(MultiType multiType) {
        while (multiType != null) {
            if (multiType == this) {
                return true;
            }
            multiType = multiType.mergeSource;
        }
        return false;
    }

    @Override
    public Type merge(Type type) {
        Object object;
        Object object2;
        if (this == type) {
            return this;
        }
        if (type == UNINIT) {
            return this;
        }
        if (type == BOGUS) {
            return BOGUS;
        }
        if (type == null) {
            return this;
        }
        if (this.resolved != null) {
            return this.resolved.merge(type);
        }
        if (this.potentialClass != null && (!((Type)(object2 = this.potentialClass.merge(type))).equals(this.potentialClass) || ((Type)object2).popChanged())) {
            this.potentialClass = Type.OBJECT.equals(object2) ? null : object2;
            this.changed = true;
        }
        if (type instanceof MultiType) {
            object = (MultiType)type;
            if (((MultiType)object).resolved != null) {
                object2 = this.mergeMultiAndSingle(this, ((MultiType)object).resolved);
            } else {
                object2 = this.mergeMultiInterfaces((MultiType)object, this);
                if (!this.inMergeSource((MultiType)object)) {
                    this.mergeSource = object;
                }
            }
        } else {
            object2 = this.mergeMultiAndSingle(this, type);
        }
        if (object2.size() > 1 || object2.size() == 1 && this.potentialClass != null) {
            if (object2.size() != this.interfaces.size()) {
                this.changed = true;
            } else if (!this.changed) {
                object = object2.keySet().iterator();
                while (object.hasNext()) {
                    if (this.interfaces.containsKey(object.next())) continue;
                    this.changed = true;
                }
            }
            this.interfaces = object2;
            this.propogateState();
            return this;
        }
        this.resolved = object2.size() == 1 ? Type.get((CtClass)object2.values().iterator().next()) : (this.potentialClass != null ? this.potentialClass : OBJECT);
        this.propogateResolved();
        return this.resolved;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MultiType)) {
            return false;
        }
        MultiType multiType = (MultiType)object;
        if (this.resolved != null) {
            return this.resolved.equals(multiType.resolved);
        }
        if (multiType.resolved != null) {
            return false;
        }
        return this.interfaces.keySet().equals(multiType.interfaces.keySet());
    }

    @Override
    public String toString() {
        if (this.resolved != null) {
            return this.resolved.toString();
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        Iterator iterator = this.interfaces.keySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            stringBuffer.append(", ");
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        if (this.potentialClass != null) {
            stringBuffer.append(", *").append(this.potentialClass.toString());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

