/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javassist.CtClass;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;

public class SignatureAttribute
extends AttributeInfo {
    public static final String tag = "Signature";

    SignatureAttribute(ConstPool constPool, int n, DataInputStream dataInputStream) {
        super(constPool, n, dataInputStream);
    }

    public SignatureAttribute(ConstPool constPool, String string) {
        super(constPool, tag);
        int n = constPool.addUtf8Info(string);
        byte[] byArray = new byte[]{(byte)(n >>> 8), (byte)n};
        this.set(byArray);
    }

    public String getSignature() {
        return this.getConstPool().getUtf8Info(ByteArray.readU16bit(this.get(), 0));
    }

    public void setSignature(String string) {
        int n = this.getConstPool().addUtf8Info(string);
        ByteArray.write16bit(n, this.info, 0);
    }

    @Override
    public AttributeInfo copy(ConstPool constPool, Map map) {
        return new SignatureAttribute(constPool, this.getSignature());
    }

    @Override
    void renameClass(String string, String string2) {
        String string3 = SignatureAttribute.renameClass(this.getSignature(), string, string2);
        this.setSignature(string3);
    }

    @Override
    void renameClass(Map map) {
        String string = SignatureAttribute.renameClass(this.getSignature(), map);
        this.setSignature(string);
    }

    static String renameClass(String string, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string2, string3);
        return SignatureAttribute.renameClass(string, hashMap);
    }

    static String renameClass(String string, Map map) {
        int n;
        if (map == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf(76, n3)) >= 0) {
            char c;
            StringBuilder stringBuilder2 = new StringBuilder();
            int n4 = n;
            try {
                while ((c = string.charAt(++n4)) != ';') {
                    stringBuilder2.append(c);
                    if (c != '<') continue;
                    while ((c = string.charAt(++n4)) != '>') {
                        stringBuilder2.append(c);
                    }
                    stringBuilder2.append(c);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            n3 = n4 + 1;
            String string2 = stringBuilder2.toString();
            String string3 = (String)map.get(string2);
            if (string3 == null) continue;
            stringBuilder.append(string.substring(n2, n));
            stringBuilder.append('L');
            stringBuilder.append(string3);
            stringBuilder.append(c);
            n2 = n3;
        }
        if (n2 == 0) {
            return string;
        }
        n = string.length();
        if (n2 < n) {
            stringBuilder.append(string.substring(n2, n));
        }
        return stringBuilder.toString();
    }

    private static boolean isNamePart(int n) {
        return n != 59 && n != 60;
    }

    public static ClassSignature toClassSignature(String string) {
        try {
            return SignatureAttribute.parseSig(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(string);
        }
    }

    public static MethodSignature toMethodSignature(String string) {
        try {
            return SignatureAttribute.parseMethodSig(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(string);
        }
    }

    public static ObjectType toFieldSignature(String string) {
        try {
            return SignatureAttribute.parseObjectType(string, new Cursor(), false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(string);
        }
    }

    public static Type toTypeSignature(String string) {
        try {
            return SignatureAttribute.parseType(string, new Cursor());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SignatureAttribute.error(string);
        }
    }

    private static ClassSignature parseSig(String string) {
        Cursor cursor = new Cursor();
        TypeParameter[] typeParameterArray = SignatureAttribute.parseTypeParams(string, cursor);
        ClassType classType = SignatureAttribute.parseClassType(string, cursor);
        int n = string.length();
        ArrayList<ClassType> arrayList = new ArrayList<ClassType>();
        while (cursor.position < n && string.charAt(cursor.position) == 'L') {
            arrayList.add(SignatureAttribute.parseClassType(string, cursor));
        }
        ClassType[] classTypeArray = arrayList.toArray(new ClassType[arrayList.size()]);
        return new ClassSignature(typeParameterArray, classType, classTypeArray);
    }

    private static MethodSignature parseMethodSig(String string) {
        Object object;
        Type type;
        Cursor cursor = new Cursor();
        TypeParameter[] typeParameterArray = SignatureAttribute.parseTypeParams(string, cursor);
        if (string.charAt(cursor.position++) != '(') {
            throw SignatureAttribute.error(string);
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        while (string.charAt(cursor.position) != ')') {
            type = SignatureAttribute.parseType(string, cursor);
            arrayList.add(type);
        }
        ++cursor.position;
        type = SignatureAttribute.parseType(string, cursor);
        int n = string.length();
        ArrayList<Type[]> arrayList2 = new ArrayList<Type[]>();
        while (cursor.position < n && string.charAt(cursor.position) == '^') {
            ++cursor.position;
            object = SignatureAttribute.parseObjectType(string, cursor, false);
            if (object instanceof ArrayType) {
                throw SignatureAttribute.error(string);
            }
            arrayList2.add((Type[])object);
        }
        object = arrayList.toArray(new Type[arrayList.size()]);
        ObjectType[] objectTypeArray = arrayList2.toArray(new ObjectType[arrayList2.size()]);
        return new MethodSignature(typeParameterArray, (Type[])object, type, objectTypeArray);
    }

    private static TypeParameter[] parseTypeParams(String string, Cursor cursor) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string.charAt(cursor.position) == '<') {
            ++cursor.position;
            while (string.charAt(cursor.position) != '>') {
                Object object;
                int n = cursor.position;
                int n2 = cursor.indexOf(string, 58);
                ObjectType objectType = SignatureAttribute.parseObjectType(string, cursor, true);
                ArrayList<ObjectType> arrayList2 = new ArrayList<ObjectType>();
                while (string.charAt(cursor.position) == ':') {
                    ++cursor.position;
                    object = SignatureAttribute.parseObjectType(string, cursor, false);
                    arrayList2.add((ObjectType)object);
                }
                object = new TypeParameter(string, n, n2, objectType, arrayList2.toArray(new ObjectType[arrayList2.size()]));
                arrayList.add(object);
            }
            ++cursor.position;
        }
        return arrayList.toArray(new TypeParameter[arrayList.size()]);
    }

    private static ObjectType parseObjectType(String string, Cursor cursor, boolean bl) {
        int n = cursor.position;
        switch (string.charAt(n)) {
            case 'L': {
                return SignatureAttribute.parseClassType2(string, cursor, null);
            }
            case 'T': {
                int n2 = cursor.indexOf(string, 59);
                return new TypeVariable(string, n + 1, n2);
            }
            case '[': {
                return SignatureAttribute.parseArray(string, cursor);
            }
        }
        if (bl) {
            return null;
        }
        throw SignatureAttribute.error(string);
    }

    private static ClassType parseClassType(String string, Cursor cursor) {
        if (string.charAt(cursor.position) == 'L') {
            return SignatureAttribute.parseClassType2(string, cursor, null);
        }
        throw SignatureAttribute.error(string);
    }

    private static ClassType parseClassType2(String string, Cursor cursor, ClassType classType) {
        TypeArgument[] typeArgumentArray;
        char c;
        int n = ++cursor.position;
        while ((c = string.charAt(cursor.position++)) != '$' && c != '<' && c != ';') {
        }
        int n2 = cursor.position - 1;
        if (c == '<') {
            typeArgumentArray = SignatureAttribute.parseTypeArgs(string, cursor);
            c = string.charAt(cursor.position++);
        } else {
            typeArgumentArray = null;
        }
        ClassType classType2 = ClassType.make(string, n, n2, typeArgumentArray, classType);
        if (c == '$' || c == '.') {
            --cursor.position;
            return SignatureAttribute.parseClassType2(string, cursor, classType2);
        }
        return classType2;
    }

    private static TypeArgument[] parseTypeArgs(String string, Cursor cursor) {
        char c;
        ArrayList<TypeArgument> arrayList = new ArrayList<TypeArgument>();
        while ((c = string.charAt(cursor.position++)) != '>') {
            TypeArgument typeArgument;
            if (c == '*') {
                typeArgument = new TypeArgument(null, '*');
            } else {
                if (c != '+' && c != '-') {
                    c = ' ';
                    --cursor.position;
                }
                typeArgument = new TypeArgument(SignatureAttribute.parseObjectType(string, cursor, false), c);
            }
            arrayList.add(typeArgument);
        }
        return arrayList.toArray(new TypeArgument[arrayList.size()]);
    }

    private static ObjectType parseArray(String string, Cursor cursor) {
        int n = 1;
        while (string.charAt(++cursor.position) == '[') {
            ++n;
        }
        return new ArrayType(n, SignatureAttribute.parseType(string, cursor));
    }

    private static Type parseType(String string, Cursor cursor) {
        Type type = SignatureAttribute.parseObjectType(string, cursor, true);
        if (type == null) {
            type = new BaseType(string.charAt(cursor.position++));
        }
        return type;
    }

    private static BadBytecode error(String string) {
        return new BadBytecode("bad signature: " + string);
    }

    public static class TypeVariable
    extends ObjectType {
        String name;

        TypeVariable(String string, int n, int n2) {
            this.name = string.substring(n, n2);
        }

        public TypeVariable(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        void encode(StringBuffer stringBuffer) {
            stringBuffer.append('T').append(this.name).append(';');
        }
    }

    public static class ArrayType
    extends ObjectType {
        int dim;
        Type componentType;

        public ArrayType(int n, Type type) {
            this.dim = n;
            this.componentType = type;
        }

        public int getDimension() {
            return this.dim;
        }

        public Type getComponentType() {
            return this.componentType;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.componentType.toString());
            for (int i = 0; i < this.dim; ++i) {
                stringBuffer.append("[]");
            }
            return stringBuffer.toString();
        }

        @Override
        void encode(StringBuffer stringBuffer) {
            for (int i = 0; i < this.dim; ++i) {
                stringBuffer.append('[');
            }
            this.componentType.encode(stringBuffer);
        }
    }

    public static class NestedClassType
    extends ClassType {
        ClassType parent;

        NestedClassType(String string, int n, int n2, TypeArgument[] typeArgumentArray, ClassType classType) {
            super(string, n, n2, typeArgumentArray);
            this.parent = classType;
        }

        public NestedClassType(ClassType classType, String string, TypeArgument[] typeArgumentArray) {
            super(string, typeArgumentArray);
            this.parent = classType;
        }

        @Override
        public ClassType getDeclaringClass() {
            return this.parent;
        }
    }

    public static class ClassType
    extends ObjectType {
        String name;
        TypeArgument[] arguments;
        public static ClassType OBJECT = new ClassType("java.lang.Object", null);

        static ClassType make(String string, int n, int n2, TypeArgument[] typeArgumentArray, ClassType classType) {
            if (classType == null) {
                return new ClassType(string, n, n2, typeArgumentArray);
            }
            return new NestedClassType(string, n, n2, typeArgumentArray, classType);
        }

        ClassType(String string, int n, int n2, TypeArgument[] typeArgumentArray) {
            this.name = string.substring(n, n2).replace('/', '.');
            this.arguments = typeArgumentArray;
        }

        public ClassType(String string, TypeArgument[] typeArgumentArray) {
            this.name = string;
            this.arguments = typeArgumentArray;
        }

        public ClassType(String string) {
            this(string, null);
        }

        public String getName() {
            return this.name;
        }

        public TypeArgument[] getTypeArguments() {
            return this.arguments;
        }

        public ClassType getDeclaringClass() {
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            ClassType classType = this.getDeclaringClass();
            if (classType != null) {
                stringBuffer.append(classType.toString()).append('.');
            }
            return this.toString2(stringBuffer);
        }

        private String toString2(StringBuffer stringBuffer) {
            stringBuffer.append(this.name);
            if (this.arguments != null) {
                stringBuffer.append('<');
                int n = this.arguments.length;
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.arguments[i].toString());
                }
                stringBuffer.append('>');
            }
            return stringBuffer.toString();
        }

        @Override
        public String jvmTypeName() {
            StringBuffer stringBuffer = new StringBuffer();
            ClassType classType = this.getDeclaringClass();
            if (classType != null) {
                stringBuffer.append(classType.jvmTypeName()).append('$');
            }
            return this.toString2(stringBuffer);
        }

        @Override
        void encode(StringBuffer stringBuffer) {
            stringBuffer.append('L');
            this.encode2(stringBuffer);
            stringBuffer.append(';');
        }

        void encode2(StringBuffer stringBuffer) {
            ClassType classType = this.getDeclaringClass();
            if (classType != null) {
                classType.encode2(stringBuffer);
                stringBuffer.append('$');
            }
            stringBuffer.append(this.name.replace('.', '/'));
            if (this.arguments != null) {
                TypeArgument.encode(stringBuffer, this.arguments);
            }
        }
    }

    public static abstract class ObjectType
    extends Type {
        public String encode() {
            StringBuffer stringBuffer = new StringBuffer();
            this.encode(stringBuffer);
            return stringBuffer.toString();
        }
    }

    public static class BaseType
    extends Type {
        char descriptor;

        BaseType(char c) {
            this.descriptor = c;
        }

        public BaseType(String string) {
            this(Descriptor.of(string).charAt(0));
        }

        public char getDescriptor() {
            return this.descriptor;
        }

        public CtClass getCtlass() {
            return Descriptor.toPrimitiveClass(this.descriptor);
        }

        public String toString() {
            return Descriptor.toClassName(Character.toString(this.descriptor));
        }

        @Override
        void encode(StringBuffer stringBuffer) {
            stringBuffer.append(this.descriptor);
        }
    }

    public static abstract class Type {
        abstract void encode(StringBuffer var1);

        static void toString(StringBuffer stringBuffer, Type[] typeArray) {
            for (int i = 0; i < typeArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(typeArray[i]);
            }
        }

        public String jvmTypeName() {
            return this.toString();
        }
    }

    public static class TypeArgument {
        ObjectType arg;
        char wildcard;

        TypeArgument(ObjectType objectType, char c) {
            this.arg = objectType;
            this.wildcard = c;
        }

        public TypeArgument(ObjectType objectType) {
            this(objectType, ' ');
        }

        public TypeArgument() {
            this(null, '*');
        }

        public static TypeArgument subclassOf(ObjectType objectType) {
            return new TypeArgument(objectType, '+');
        }

        public static TypeArgument superOf(ObjectType objectType) {
            return new TypeArgument(objectType, '-');
        }

        public char getKind() {
            return this.wildcard;
        }

        public boolean isWildcard() {
            return this.wildcard != ' ';
        }

        public ObjectType getType() {
            return this.arg;
        }

        public String toString() {
            if (this.wildcard == '*') {
                return "?";
            }
            String string = this.arg.toString();
            if (this.wildcard == ' ') {
                return string;
            }
            if (this.wildcard == '+') {
                return "? extends " + string;
            }
            return "? super " + string;
        }

        static void encode(StringBuffer stringBuffer, TypeArgument[] typeArgumentArray) {
            stringBuffer.append('<');
            for (int i = 0; i < typeArgumentArray.length; ++i) {
                TypeArgument typeArgument = typeArgumentArray[i];
                if (typeArgument.isWildcard()) {
                    stringBuffer.append(typeArgument.wildcard);
                }
                if (typeArgument.getType() == null) continue;
                typeArgument.getType().encode(stringBuffer);
            }
            stringBuffer.append('>');
        }
    }

    public static class TypeParameter {
        String name;
        ObjectType superClass;
        ObjectType[] superInterfaces;

        TypeParameter(String string, int n, int n2, ObjectType objectType, ObjectType[] objectTypeArray) {
            this.name = string.substring(n, n2);
            this.superClass = objectType;
            this.superInterfaces = objectTypeArray;
        }

        public TypeParameter(String string, ObjectType objectType, ObjectType[] objectTypeArray) {
            this.name = string;
            this.superClass = objectType;
            this.superInterfaces = objectTypeArray == null ? new ObjectType[0] : objectTypeArray;
        }

        public TypeParameter(String string) {
            this(string, null, null);
        }

        public String getName() {
            return this.name;
        }

        public ObjectType getClassBound() {
            return this.superClass;
        }

        public ObjectType[] getInterfaceBound() {
            return this.superInterfaces;
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer(this.getName());
            if (this.superClass != null) {
                stringBuffer.append(" extends ").append(this.superClass.toString());
            }
            if ((n = this.superInterfaces.length) > 0) {
                for (int i = 0; i < n; ++i) {
                    if (i > 0 || this.superClass != null) {
                        stringBuffer.append(" & ");
                    } else {
                        stringBuffer.append(" extends ");
                    }
                    stringBuffer.append(this.superInterfaces[i].toString());
                }
            }
            return stringBuffer.toString();
        }

        static void toString(StringBuffer stringBuffer, TypeParameter[] typeParameterArray) {
            stringBuffer.append('<');
            for (int i = 0; i < typeParameterArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(typeParameterArray[i]);
            }
            stringBuffer.append('>');
        }

        void encode(StringBuffer stringBuffer) {
            stringBuffer.append(this.name);
            if (this.superClass == null) {
                stringBuffer.append(":Ljava/lang/Object;");
            } else {
                stringBuffer.append(':');
                this.superClass.encode(stringBuffer);
            }
            for (int i = 0; i < this.superInterfaces.length; ++i) {
                stringBuffer.append(':');
                this.superInterfaces[i].encode(stringBuffer);
            }
        }
    }

    public static class MethodSignature {
        TypeParameter[] typeParams;
        Type[] params;
        Type retType;
        ObjectType[] exceptions;

        public MethodSignature(TypeParameter[] typeParameterArray, Type[] typeArray, Type type, ObjectType[] objectTypeArray) {
            this.typeParams = typeParameterArray == null ? new TypeParameter[]{} : typeParameterArray;
            this.params = typeArray == null ? new Type[]{} : typeArray;
            this.retType = type == null ? new BaseType("void") : type;
            this.exceptions = objectTypeArray == null ? new ObjectType[]{} : objectTypeArray;
        }

        public TypeParameter[] getTypeParameters() {
            return this.typeParams;
        }

        public Type[] getParameterTypes() {
            return this.params;
        }

        public Type getReturnType() {
            return this.retType;
        }

        public ObjectType[] getExceptionTypes() {
            return this.exceptions;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            TypeParameter.toString(stringBuffer, this.typeParams);
            stringBuffer.append(" (");
            Type.toString(stringBuffer, this.params);
            stringBuffer.append(") ");
            stringBuffer.append(this.retType);
            if (this.exceptions.length > 0) {
                stringBuffer.append(" throws ");
                Type.toString(stringBuffer, this.exceptions);
            }
            return stringBuffer.toString();
        }

        public String encode() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.typeParams.length > 0) {
                stringBuffer.append('<');
                for (n = 0; n < this.typeParams.length; ++n) {
                    this.typeParams[n].encode(stringBuffer);
                }
                stringBuffer.append('>');
            }
            stringBuffer.append('(');
            for (n = 0; n < this.params.length; ++n) {
                this.params[n].encode(stringBuffer);
            }
            stringBuffer.append(')');
            this.retType.encode(stringBuffer);
            if (this.exceptions.length > 0) {
                for (n = 0; n < this.exceptions.length; ++n) {
                    stringBuffer.append('^');
                    this.exceptions[n].encode(stringBuffer);
                }
            }
            return stringBuffer.toString();
        }
    }

    public static class ClassSignature {
        TypeParameter[] params;
        ClassType superClass;
        ClassType[] interfaces;

        public ClassSignature(TypeParameter[] typeParameterArray, ClassType classType, ClassType[] classTypeArray) {
            this.params = typeParameterArray == null ? new TypeParameter[]{} : typeParameterArray;
            this.superClass = classType == null ? ClassType.OBJECT : classType;
            this.interfaces = classTypeArray == null ? new ClassType[]{} : classTypeArray;
        }

        public ClassSignature(TypeParameter[] typeParameterArray) {
            this(typeParameterArray, null, null);
        }

        public TypeParameter[] getParameters() {
            return this.params;
        }

        public ClassType getSuperClass() {
            return this.superClass;
        }

        public ClassType[] getInterfaces() {
            return this.interfaces;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            TypeParameter.toString(stringBuffer, this.params);
            stringBuffer.append(" extends ").append(this.superClass);
            if (this.interfaces.length > 0) {
                stringBuffer.append(" implements ");
                Type.toString(stringBuffer, this.interfaces);
            }
            return stringBuffer.toString();
        }

        public String encode() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.params.length > 0) {
                stringBuffer.append('<');
                for (n = 0; n < this.params.length; ++n) {
                    this.params[n].encode(stringBuffer);
                }
                stringBuffer.append('>');
            }
            this.superClass.encode(stringBuffer);
            for (n = 0; n < this.interfaces.length; ++n) {
                this.interfaces[n].encode(stringBuffer);
            }
            return stringBuffer.toString();
        }
    }

    private static class Cursor {
        int position = 0;

        private Cursor() {
        }

        int indexOf(String string, int n) {
            int n2 = string.indexOf(n, this.position);
            if (n2 < 0) {
                throw SignatureAttribute.error(string);
            }
            this.position = n2 + 1;
            return n2;
        }
    }
}

