/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.PrintWriter;
import java.util.List;
import javassist.Modifier;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.StackMap;
import javassist.bytecode.StackMapTable;

public class ClassFilePrinter {
    public static void print(ClassFile classFile) {
        ClassFilePrinter.print(classFile, new PrintWriter(System.out, true));
    }

    public static void print(ClassFile classFile, PrintWriter printWriter) {
        int n;
        Object object;
        int n2;
        int n3 = AccessFlag.toModifier(classFile.getAccessFlags() & 0xFFFFFFDF);
        printWriter.println("major: " + classFile.major + ", minor: " + classFile.minor + " modifiers: " + Integer.toHexString(classFile.getAccessFlags()));
        printWriter.println(Modifier.toString(n3) + " class " + classFile.getName() + " extends " + classFile.getSuperclass());
        String[] stringArray = classFile.getInterfaces();
        if (stringArray != null && stringArray.length > 0) {
            printWriter.print("    implements ");
            printWriter.print(stringArray[0]);
            for (n2 = 1; n2 < stringArray.length; ++n2) {
                printWriter.print(", " + stringArray[n2]);
            }
            printWriter.println();
        }
        printWriter.println();
        List list = classFile.getFields();
        int n4 = list.size();
        for (n2 = 0; n2 < n4; ++n2) {
            object = (FieldInfo)list.get(n2);
            n = ((FieldInfo)object).getAccessFlags();
            printWriter.println(Modifier.toString(AccessFlag.toModifier(n)) + " " + ((FieldInfo)object).getName() + "\t" + ((FieldInfo)object).getDescriptor());
            ClassFilePrinter.printAttributes(((FieldInfo)object).getAttributes(), printWriter, 'f');
        }
        printWriter.println();
        list = classFile.getMethods();
        n4 = list.size();
        for (n2 = 0; n2 < n4; ++n2) {
            object = (MethodInfo)list.get(n2);
            n = ((MethodInfo)object).getAccessFlags();
            printWriter.println(Modifier.toString(AccessFlag.toModifier(n)) + " " + ((MethodInfo)object).getName() + "\t" + ((MethodInfo)object).getDescriptor());
            ClassFilePrinter.printAttributes(((MethodInfo)object).getAttributes(), printWriter, 'm');
            printWriter.println();
        }
        printWriter.println();
        ClassFilePrinter.printAttributes(classFile.getAttributes(), printWriter, 'c');
    }

    static void printAttributes(List list, PrintWriter printWriter, char c) {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attributeInfo;
            AttributeInfo attributeInfo2 = (AttributeInfo)list.get(i);
            if (attributeInfo2 instanceof CodeAttribute) {
                attributeInfo = (CodeAttribute)attributeInfo2;
                printWriter.println("attribute: " + attributeInfo2.getName() + ": " + attributeInfo2.getClass().getName());
                printWriter.println("max stack " + ((CodeAttribute)attributeInfo).getMaxStack() + ", max locals " + ((CodeAttribute)attributeInfo).getMaxLocals() + ", " + ((CodeAttribute)attributeInfo).getExceptionTable().size() + " catch blocks");
                printWriter.println("<code attribute begin>");
                ClassFilePrinter.printAttributes(((CodeAttribute)attributeInfo).getAttributes(), printWriter, c);
                printWriter.println("<code attribute end>");
                continue;
            }
            if (attributeInfo2 instanceof AnnotationsAttribute) {
                printWriter.println("annnotation: " + attributeInfo2.toString());
                continue;
            }
            if (attributeInfo2 instanceof ParameterAnnotationsAttribute) {
                printWriter.println("parameter annnotations: " + attributeInfo2.toString());
                continue;
            }
            if (attributeInfo2 instanceof StackMapTable) {
                printWriter.println("<stack map table begin>");
                StackMapTable.Printer.print((StackMapTable)attributeInfo2, printWriter);
                printWriter.println("<stack map table end>");
                continue;
            }
            if (attributeInfo2 instanceof StackMap) {
                printWriter.println("<stack map begin>");
                ((StackMap)attributeInfo2).print(printWriter);
                printWriter.println("<stack map end>");
                continue;
            }
            if (attributeInfo2 instanceof SignatureAttribute) {
                attributeInfo = (SignatureAttribute)attributeInfo2;
                String string = ((SignatureAttribute)attributeInfo).getSignature();
                printWriter.println("signature: " + string);
                try {
                    String string2 = c == 'c' ? SignatureAttribute.toClassSignature(string).toString() : (c == 'm' ? SignatureAttribute.toMethodSignature(string).toString() : SignatureAttribute.toFieldSignature(string).toString());
                    printWriter.println("           " + string2);
                }
                catch (BadBytecode badBytecode) {
                    printWriter.println("           syntax error");
                }
                continue;
            }
            printWriter.println("attribute: " + attributeInfo2.getName() + " (" + attributeInfo2.get().length + " byte): " + attributeInfo2.getClass().getName());
        }
    }
}

