/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.InnerClassesAttribute;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SourceFileAttribute;

public final class ClassFile {
    int major;
    int minor;
    ConstPool constPool;
    int thisClass;
    int accessFlags;
    int superClass;
    int[] interfaces;
    ArrayList fields;
    ArrayList methods;
    ArrayList attributes;
    String thisclassname;
    String[] cachedInterfaces;
    String cachedSuperclass;
    public static final int JAVA_1 = 45;
    public static final int JAVA_2 = 46;
    public static final int JAVA_3 = 47;
    public static final int JAVA_4 = 48;
    public static final int JAVA_5 = 49;
    public static final int JAVA_6 = 50;
    public static final int JAVA_7 = 51;
    public static final int JAVA_8 = 52;
    public static final int MAJOR_VERSION;

    public ClassFile(DataInputStream dataInputStream) {
        this.read(dataInputStream);
    }

    public ClassFile(boolean bl, String string, String string2) {
        this.major = MAJOR_VERSION;
        this.minor = 0;
        this.constPool = new ConstPool(string);
        this.thisClass = this.constPool.getThisClassInfo();
        this.accessFlags = bl ? 1536 : 32;
        this.initSuperclass(string2);
        this.interfaces = null;
        this.fields = new ArrayList();
        this.methods = new ArrayList();
        this.thisclassname = string;
        this.attributes = new ArrayList();
        this.attributes.add(new SourceFileAttribute(this.constPool, ClassFile.getSourcefileName(this.thisclassname)));
    }

    private void initSuperclass(String string) {
        if (string != null) {
            this.superClass = this.constPool.addClassInfo(string);
            this.cachedSuperclass = string;
        } else {
            this.superClass = this.constPool.addClassInfo("java.lang.Object");
            this.cachedSuperclass = "java.lang.Object";
        }
    }

    private static String getSourcefileName(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string + ".java";
    }

    public void compact() {
        Object object;
        int n;
        ConstPool constPool = this.compact0();
        ArrayList arrayList = this.methods;
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (MethodInfo)arrayList.get(n);
            ((MethodInfo)object).compact(constPool);
        }
        arrayList = this.fields;
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (FieldInfo)arrayList.get(n);
            ((FieldInfo)object).compact(constPool);
        }
        this.attributes = AttributeInfo.copyAll(this.attributes, constPool);
        this.constPool = constPool;
    }

    private ConstPool compact0() {
        ConstPool constPool = new ConstPool(this.thisclassname);
        this.thisClass = constPool.getThisClassInfo();
        String string = this.getSuperclass();
        if (string != null) {
            this.superClass = constPool.addClassInfo(this.getSuperclass());
        }
        if (this.interfaces != null) {
            int n = this.interfaces.length;
            for (int i = 0; i < n; ++i) {
                this.interfaces[i] = constPool.addClassInfo(this.constPool.getClassInfo(this.interfaces[i]));
            }
        }
        return constPool;
    }

    public void prune() {
        Object object;
        int n;
        AttributeInfo attributeInfo;
        AttributeInfo attributeInfo2;
        ConstPool constPool = this.compact0();
        ArrayList<AttributeInfo> arrayList = new ArrayList<AttributeInfo>();
        AttributeInfo attributeInfo3 = this.getAttribute("RuntimeInvisibleAnnotations");
        if (attributeInfo3 != null) {
            attributeInfo3 = attributeInfo3.copy(constPool, null);
            arrayList.add(attributeInfo3);
        }
        if ((attributeInfo2 = this.getAttribute("RuntimeVisibleAnnotations")) != null) {
            attributeInfo2 = attributeInfo2.copy(constPool, null);
            arrayList.add(attributeInfo2);
        }
        if ((attributeInfo = this.getAttribute("Signature")) != null) {
            attributeInfo = attributeInfo.copy(constPool, null);
            arrayList.add(attributeInfo);
        }
        ArrayList arrayList2 = this.methods;
        int n2 = arrayList2.size();
        for (n = 0; n < n2; ++n) {
            object = (MethodInfo)arrayList2.get(n);
            ((MethodInfo)object).prune(constPool);
        }
        arrayList2 = this.fields;
        n2 = arrayList2.size();
        for (n = 0; n < n2; ++n) {
            object = (FieldInfo)arrayList2.get(n);
            ((FieldInfo)object).prune(constPool);
        }
        this.attributes = arrayList;
        this.constPool = constPool;
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int n) {
        if ((n & 0x200) == 0) {
            n |= 0x20;
        }
        this.accessFlags = n;
    }

    public int getInnerAccessFlags() {
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)this.getAttribute("InnerClasses");
        if (innerClassesAttribute == null) {
            return -1;
        }
        String string = this.getName();
        int n = innerClassesAttribute.tableLength();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(innerClassesAttribute.innerClass(i))) continue;
            return innerClassesAttribute.accessFlags(i);
        }
        return -1;
    }

    public String getName() {
        return this.thisclassname;
    }

    public void setName(String string) {
        this.renameClass(this.thisclassname, string);
    }

    public String getSuperclass() {
        if (this.cachedSuperclass == null) {
            this.cachedSuperclass = this.constPool.getClassInfo(this.superClass);
        }
        return this.cachedSuperclass;
    }

    public int getSuperclassId() {
        return this.superClass;
    }

    public void setSuperclass(String string) {
        if (string == null) {
            string = "java.lang.Object";
        }
        try {
            this.superClass = this.constPool.addClassInfo(string);
            ArrayList arrayList = this.methods;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                MethodInfo methodInfo = (MethodInfo)arrayList.get(i);
                methodInfo.setSuperclass(string);
            }
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
        this.cachedSuperclass = string;
    }

    public final void renameClass(String string, String string2) {
        String string3;
        Object object;
        int n;
        if (string.equals(string2)) {
            return;
        }
        if (string.equals(this.thisclassname)) {
            this.thisclassname = string2;
        }
        string = Descriptor.toJvmName(string);
        string2 = Descriptor.toJvmName(string2);
        this.constPool.renameClass(string, string2);
        AttributeInfo.renameClass(this.attributes, string, string2);
        ArrayList arrayList = this.methods;
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (MethodInfo)arrayList.get(n);
            string3 = ((MethodInfo)object).getDescriptor();
            ((MethodInfo)object).setDescriptor(Descriptor.rename(string3, string, string2));
            AttributeInfo.renameClass(((MethodInfo)object).getAttributes(), string, string2);
        }
        arrayList = this.fields;
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (FieldInfo)arrayList.get(n);
            string3 = ((FieldInfo)object).getDescriptor();
            ((FieldInfo)object).setDescriptor(Descriptor.rename(string3, string, string2));
            AttributeInfo.renameClass(((FieldInfo)object).getAttributes(), string, string2);
        }
    }

    public final void renameClass(Map map) {
        String string;
        Object object;
        int n;
        String string2 = (String)map.get(Descriptor.toJvmName(this.thisclassname));
        if (string2 != null) {
            this.thisclassname = Descriptor.toJavaName(string2);
        }
        this.constPool.renameClass(map);
        AttributeInfo.renameClass(this.attributes, map);
        ArrayList arrayList = this.methods;
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (MethodInfo)arrayList.get(n);
            string = ((MethodInfo)object).getDescriptor();
            ((MethodInfo)object).setDescriptor(Descriptor.rename(string, map));
            AttributeInfo.renameClass(((MethodInfo)object).getAttributes(), map);
        }
        arrayList = this.fields;
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (FieldInfo)arrayList.get(n);
            string = ((FieldInfo)object).getDescriptor();
            ((FieldInfo)object).setDescriptor(Descriptor.rename(string, map));
            AttributeInfo.renameClass(((FieldInfo)object).getAttributes(), map);
        }
    }

    public final void getRefClasses(Map map) {
        String string;
        Object object;
        int n;
        this.constPool.renameClass(map);
        AttributeInfo.getRefClasses(this.attributes, map);
        ArrayList arrayList = this.methods;
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (MethodInfo)arrayList.get(n);
            string = ((MethodInfo)object).getDescriptor();
            Descriptor.rename(string, map);
            AttributeInfo.getRefClasses(((MethodInfo)object).getAttributes(), map);
        }
        arrayList = this.fields;
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (FieldInfo)arrayList.get(n);
            string = ((FieldInfo)object).getDescriptor();
            Descriptor.rename(string, map);
            AttributeInfo.getRefClasses(((FieldInfo)object).getAttributes(), map);
        }
    }

    public String[] getInterfaces() {
        if (this.cachedInterfaces != null) {
            return this.cachedInterfaces;
        }
        String[] stringArray = null;
        if (this.interfaces == null) {
            stringArray = new String[]{};
        } else {
            int n = this.interfaces.length;
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = this.constPool.getClassInfo(this.interfaces[i]);
            }
            stringArray = stringArray2;
        }
        this.cachedInterfaces = stringArray;
        return stringArray;
    }

    public void setInterfaces(String[] stringArray) {
        this.cachedInterfaces = null;
        if (stringArray != null) {
            int n = stringArray.length;
            this.interfaces = new int[n];
            for (int i = 0; i < n; ++i) {
                this.interfaces[i] = this.constPool.addClassInfo(stringArray[i]);
            }
        }
    }

    public void addInterface(String string) {
        this.cachedInterfaces = null;
        int n = this.constPool.addClassInfo(string);
        if (this.interfaces == null) {
            this.interfaces = new int[1];
            this.interfaces[0] = n;
        } else {
            int n2 = this.interfaces.length;
            int[] nArray = new int[n2 + 1];
            System.arraycopy(this.interfaces, 0, nArray, 0, n2);
            nArray[n2] = n;
            this.interfaces = nArray;
        }
    }

    public List getFields() {
        return this.fields;
    }

    public void addField(FieldInfo fieldInfo) {
        this.testExistingField(fieldInfo.getName(), fieldInfo.getDescriptor());
        this.fields.add(fieldInfo);
    }

    public final void addField2(FieldInfo fieldInfo) {
        this.fields.add(fieldInfo);
    }

    private void testExistingField(String string, String string2) {
        ListIterator listIterator = this.fields.listIterator(0);
        while (listIterator.hasNext()) {
            FieldInfo fieldInfo = (FieldInfo)listIterator.next();
            if (!fieldInfo.getName().equals(string)) continue;
            throw new DuplicateMemberException("duplicate field: " + string);
        }
    }

    public List getMethods() {
        return this.methods;
    }

    public MethodInfo getMethod(String string) {
        ArrayList arrayList = this.methods;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo methodInfo = (MethodInfo)arrayList.get(i);
            if (!methodInfo.getName().equals(string)) continue;
            return methodInfo;
        }
        return null;
    }

    public MethodInfo getStaticInitializer() {
        return this.getMethod("<clinit>");
    }

    public void addMethod(MethodInfo methodInfo) {
        this.testExistingMethod(methodInfo);
        this.methods.add(methodInfo);
    }

    public final void addMethod2(MethodInfo methodInfo) {
        this.methods.add(methodInfo);
    }

    private void testExistingMethod(MethodInfo methodInfo) {
        String string = methodInfo.getName();
        String string2 = methodInfo.getDescriptor();
        ListIterator listIterator = this.methods.listIterator(0);
        while (listIterator.hasNext()) {
            if (!ClassFile.isDuplicated(methodInfo, string, string2, (MethodInfo)listIterator.next(), listIterator)) continue;
            throw new DuplicateMemberException("duplicate method: " + string + " in " + this.getName());
        }
    }

    private static boolean isDuplicated(MethodInfo methodInfo, String string, String string2, MethodInfo methodInfo2, ListIterator listIterator) {
        if (!methodInfo2.getName().equals(string)) {
            return false;
        }
        String string3 = methodInfo2.getDescriptor();
        if (!Descriptor.eqParamTypes(string3, string2)) {
            return false;
        }
        if (string3.equals(string2)) {
            if (ClassFile.notBridgeMethod(methodInfo2)) {
                return true;
            }
            listIterator.remove();
            return false;
        }
        return false;
    }

    private static boolean notBridgeMethod(MethodInfo methodInfo) {
        return (methodInfo.getAccessFlags() & 0x40) == 0;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public AttributeInfo getAttribute(String string) {
        ArrayList arrayList = this.attributes;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)arrayList.get(i);
            if (!attributeInfo.getName().equals(string)) continue;
            return attributeInfo;
        }
        return null;
    }

    public AttributeInfo removeAttribute(String string) {
        return AttributeInfo.remove(this.attributes, string);
    }

    public void addAttribute(AttributeInfo attributeInfo) {
        AttributeInfo.remove(this.attributes, attributeInfo.getName());
        this.attributes.add(attributeInfo);
    }

    public String getSourceFile() {
        SourceFileAttribute sourceFileAttribute = (SourceFileAttribute)this.getAttribute("SourceFile");
        if (sourceFileAttribute == null) {
            return null;
        }
        return sourceFileAttribute.getFileName();
    }

    private void read(DataInputStream dataInputStream) {
        int n;
        int n2 = dataInputStream.readInt();
        if (n2 != -889275714) {
            throw new IOException("bad magic number: " + Integer.toHexString(n2));
        }
        this.minor = dataInputStream.readUnsignedShort();
        this.major = dataInputStream.readUnsignedShort();
        this.constPool = new ConstPool(dataInputStream);
        this.accessFlags = dataInputStream.readUnsignedShort();
        this.thisClass = dataInputStream.readUnsignedShort();
        this.constPool.setThisClassInfo(this.thisClass);
        this.superClass = dataInputStream.readUnsignedShort();
        int n3 = dataInputStream.readUnsignedShort();
        if (n3 == 0) {
            this.interfaces = null;
        } else {
            this.interfaces = new int[n3];
            for (n = 0; n < n3; ++n) {
                this.interfaces[n] = dataInputStream.readUnsignedShort();
            }
        }
        ConstPool constPool = this.constPool;
        n3 = dataInputStream.readUnsignedShort();
        this.fields = new ArrayList();
        for (n = 0; n < n3; ++n) {
            this.addField2(new FieldInfo(constPool, dataInputStream));
        }
        n3 = dataInputStream.readUnsignedShort();
        this.methods = new ArrayList();
        for (n = 0; n < n3; ++n) {
            this.addMethod2(new MethodInfo(constPool, dataInputStream));
        }
        this.attributes = new ArrayList();
        n3 = dataInputStream.readUnsignedShort();
        for (n = 0; n < n3; ++n) {
            this.addAttribute(AttributeInfo.read(constPool, dataInputStream));
        }
        this.thisclassname = this.constPool.getClassInfo(this.thisClass);
    }

    public void write(DataOutputStream dataOutputStream) {
        Object object;
        int n;
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(this.minor);
        dataOutputStream.writeShort(this.major);
        this.constPool.write(dataOutputStream);
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(this.thisClass);
        dataOutputStream.writeShort(this.superClass);
        int n2 = this.interfaces == null ? 0 : this.interfaces.length;
        dataOutputStream.writeShort(n2);
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeShort(this.interfaces[n]);
        }
        ArrayList arrayList = this.fields;
        n2 = arrayList.size();
        dataOutputStream.writeShort(n2);
        for (n = 0; n < n2; ++n) {
            object = (FieldInfo)arrayList.get(n);
            ((FieldInfo)object).write(dataOutputStream);
        }
        arrayList = this.methods;
        n2 = arrayList.size();
        dataOutputStream.writeShort(n2);
        for (n = 0; n < n2; ++n) {
            object = (MethodInfo)arrayList.get(n);
            ((MethodInfo)object).write(dataOutputStream);
        }
        dataOutputStream.writeShort(this.attributes.size());
        AttributeInfo.writeAll(this.attributes, dataOutputStream);
    }

    public int getMajorVersion() {
        return this.major;
    }

    public void setMajorVersion(int n) {
        this.major = n;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public void setMinorVersion(int n) {
        this.minor = n;
    }

    public void setVersionToJava5() {
        this.major = 49;
        this.minor = 0;
    }

    static {
        int n = 47;
        try {
            Class.forName("java.lang.StringBuilder");
            n = 49;
            Class.forName("java.util.zip.DeflaterInputStream");
            n = 50;
            Class.forName("java.lang.invoke.CallSite");
            n = 51;
            Class.forName("java.util.function.Function");
            n = 52;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MAJOR_VERSION = n;
    }
}

