/*
 * Decompiled with CFR 0.152.
 */
package com.cyr1en.javen.util;

import com.cyr1en.javen.Dependency;
import com.cyr1en.javen.annotation.Lib;
import com.cyr1en.javen.util.FastStrings;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.atteo.classindex.ClassIndex;

public class JavenUtil {
    public static boolean validURL(String string) {
        try {
            URL uRL = new URL(string);
            return JavenUtil.validURL(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validURL(URL uRL) {
        HttpURLConnection httpURLConnection = JavenUtil.buildConnection(uRL);
        try {
            int n = httpURLConnection.getResponseCode();
            boolean bl = n == 200;
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    private static HttpURLConnection buildConnection(URL uRL) {
        try {
            HttpURLConnection.setFollowRedirects(true);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36");
            return httpURLConnection;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static int getFileSizeKB(URL uRL) {
        HttpURLConnection httpURLConnection = JavenUtil.buildConnection(uRL);
        httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
        try {
            int n = httpURLConnection.getContentLength() / 1024;
            return n;
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    public static List<Dependency> findAllRequestedDeps(ClassLoader ... classLoaderArray) {
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        for (Class<?> clazz : ClassIndex.getAnnotated(Lib.class)) {
            for (Lib object : (Lib[])clazz.getDeclaredAnnotationsByType(Lib.class)) {
                Lib[] libArray = FastStrings.isBlank(object.directURL()) ? null : object.directURL();
                arrayList.add(new Dependency(object.group(), object.name(), object.version(), (String)libArray));
            }
        }
        for (ClassLoader classLoader : classLoaderArray) {
            for (Class<?> clazz : ClassIndex.getAnnotated(Lib.class, classLoader)) {
                for (Lib lib : (Lib[])clazz.getDeclaredAnnotationsByType(Lib.class)) {
                    String string = FastStrings.isBlank(lib.directURL()) ? null : lib.directURL();
                    arrayList.add(new Dependency(lib.group(), lib.name(), lib.version(), string));
                }
            }
        }
        return arrayList.stream().distinct().collect(Collectors.toList());
    }

    public static Dependency dependencyByArtifactName(String string) {
        return JavenUtil.findAllRequestedDeps(new ClassLoader[0]).stream().filter(dependency -> dependency.getArtifactId().equals(string)).findFirst().orElse(null);
    }

    public static Dependency dependencyByFileName(String string) {
        String string2 = string.substring(0, string.indexOf("-"));
        return JavenUtil.dependencyByArtifactName(string2);
    }
}

