/*
 * Decompiled with CFR 0.152.
 */
package com.cyr1en.javen.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class FileUtil {
    public static boolean isJarFile(File file) {
        try {
            if (!FileUtil.isZipFile(file)) {
                return false;
            }
            ZipFile zipFile = new ZipFile(file);
            boolean bl = zipFile.getEntry("META-INF/MANIFEST.MF") != null;
            zipFile.close();
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static boolean isZipFile(File file) {
        try {
            if (!file.canRead() || file.isDirectory()) {
                return false;
            }
            if (file.length() < 4L) {
                return false;
            }
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int n = dataInputStream.readInt();
            dataInputStream.close();
            return n == 1347093252;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static JarFile getJarFile(File file) {
        if (!FileUtil.isJarFile(file)) {
            throw new IllegalArgumentException("Only jar files can be converted to JarFile");
        }
        try {
            return new JarFile(file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String getSimpleName(File file) {
        if (file == null) {
            return "null";
        }
        return file.getName().substring(file.getName().lastIndexOf("\\") + 1);
    }
}

