/*
 * Decompiled with CFR 0.152.
 */
package com.cyr1en.javen;

import com.cyr1en.javen.Dependency;
import com.cyr1en.javen.Javen;
import com.cyr1en.javen.Repositories;
import com.cyr1en.javen.Repository;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class URLResolver {
    public static final String UNRESOLVED = "unresolved";
    private Repositories repositories;

    public URLResolver(Repositories repositories) {
        this.repositories = repositories;
    }

    public List<URL> resolve(Collection<? extends Dependency> collection) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (Dependency dependency : collection) {
            arrayList.add(this.resolve(dependency));
        }
        return Collections.unmodifiableList(arrayList.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public URL resolve(Dependency dependency) {
        if (!dependency.getDirectURL().equals(UNRESOLVED)) {
            try {
                String string = dependency.getDirectURL();
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        for (Repository repository : this.repositories) {
            if (!repository.contains(dependency)) continue;
            return repository.getURLOf(dependency);
        }
        Javen.LOGGER.warn("Cannot resolve URL for " + dependency.toString() + "!");
        return null;
    }

    public Repositories getRepositories() {
        return this.repositories;
    }

    public void setRepositories(Repositories repositories) {
        this.repositories = repositories;
    }
}

