/*
 * Decompiled with CFR 0.152.
 */
package com.cyr1en.javen;

import com.cyr1en.javen.Dependency;
import com.cyr1en.javen.Javen;
import com.cyr1en.javen.util.JavenUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public class Repository {
    private String id;
    private String repositoryURL;
    private String layout;

    public Repository(String string, String string2) {
        this(string, string2, null);
    }

    public Repository(String string, String string2, String string3) {
        this.id = string;
        this.repositoryURL = this.prepareURL(string2);
        this.layout = Objects.isNull(string3) ? "default" : string3;
    }

    public String getId() {
        return this.id;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public String getLayout() {
        return this.layout;
    }

    private String prepareURL(String string) {
        String string2 = string.trim();
        return string2.endsWith("/") ? string2 : string2 + "/";
    }

    public boolean contains(Dependency dependency) {
        String string = this.getRepositoryURL() + dependency.asURL();
        try {
            URL uRL = new URL(string);
            if (JavenUtil.validURL(uRL)) {
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Javen.LOGGER.error(string + " is malformed!");
        }
        return false;
    }

    public URL getURLOf(Dependency dependency) {
        String string = this.getRepositoryURL() + dependency.asURL();
        if (!this.contains(dependency)) {
            return null;
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Javen.LOGGER.error(string + " is malformed!");
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Repository)) {
            return false;
        }
        Repository repository = (Repository)object;
        return Objects.equals(this.id, repository.id) && Objects.equals(this.repositoryURL, repository.repositoryURL);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.repositoryURL);
    }

    public String toString() {
        return "Repository{id='" + this.id + '\'' + ", repositoryURL='" + this.repositoryURL + '\'' + '}';
    }
}

