/*
 * Decompiled with CFR 0.152.
 */
package com.cyr1en.javen;

import com.cyr1en.javen.Dependency;
import com.cyr1en.javen.Javen;
import com.cyr1en.javen.util.FileUtil;
import com.cyr1en.javen.util.JavenUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LibDirectory
extends File {
    private static final String DEFAULT_PATH = System.getProperty("user.dir") + "/libs";

    public LibDirectory() {
        this(DEFAULT_PATH);
    }

    public LibDirectory(String string) {
        super(string);
        if (!this.exists()) {
            this.prepareDir();
        }
        this.assertDirectory();
    }

    public Map<Dependency, File> listDepsToLoad(ClassLoader ... classLoaderArray) {
        File[] fileArray = this.listFiles();
        if (fileArray == null) {
            return Collections.emptyMap();
        }
        HashMap<Dependency, File> hashMap = new HashMap<Dependency, File>();
        for (Dependency dependency : JavenUtil.findAllRequestedDeps(classLoaderArray)) {
            for (File file : fileArray) {
                if (!FileUtil.isJarFile(file) || !FileUtil.getSimpleName(file).equals(dependency.asJarName())) continue;
                hashMap.put(dependency, file);
            }
        }
        return hashMap;
    }

    public File[] listJarFiles() {
        File[] fileArray = this.listFiles();
        if (fileArray == null) {
            return new File[0];
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray) {
            if (!FileUtil.isJarFile(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[0]);
    }

    public File[] listJarFilesMatching(Dependency dependency) {
        File[] fileArray = this.listJarFiles();
        if (fileArray.length == 0) {
            return fileArray;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray) {
            String string = FileUtil.getSimpleName(file).toLowerCase();
            String string2 = dependency.getArtifactId().toLowerCase();
            if (!string.equalsIgnoreCase(dependency.asJarName()) && !string.contains(string2)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[0]);
    }

    public boolean containsDiffVersionOf(Dependency dependency) {
        if (!this.containsDependency(dependency)) {
            return false;
        }
        if (this.listJarFilesMatching(dependency).length > 1) {
            return true;
        }
        return true;
    }

    public void deleteDifferentVersion(Dependency dependency) {
        File[] fileArray = this.listJarFilesMatching(dependency);
        if (fileArray.length <= 1) {
            return;
        }
        for (File file : fileArray) {
            boolean bl;
            String string = LibDirectory.getVersion(file);
            Javen.LOGGER.info("Checking: " + string + " & " + dependency.getVersion());
            if (dependency.getVersion().equalsIgnoreCase(string) || (bl = file.delete())) continue;
            Javen.LOGGER.warn("Wasn't able to remove " + FileUtil.getSimpleName(file));
        }
    }

    public void deleteDependency(Dependency dependency) {
        for (File file : this.listJarFiles()) {
            boolean bl;
            String string = FileUtil.getSimpleName(file);
            if (!string.equalsIgnoreCase(dependency.asJarName()) || (bl = file.delete())) continue;
            Javen.LOGGER.warn("Was not able to delete {}, deleting on program exit.", (Object)dependency.asJarName());
            file.deleteOnExit();
        }
    }

    public boolean containsDependency(Dependency dependency) {
        File[] fileArray;
        for (File file : fileArray = this.listJarFiles()) {
            String string = FileUtil.getSimpleName(file);
            if (!string.equalsIgnoreCase(dependency.asJarName())) continue;
            return true;
        }
        return false;
    }

    private static String getVersion(File file) {
        String string = FileUtil.getSimpleName(file);
        return string.substring(string.indexOf("-") + 1).replace(".jar", "");
    }

    private void assertDirectory() {
        if (!this.isDirectory()) {
            throw new IllegalStateException("LibDirectory can only be a directory file!");
        }
    }

    private void prepareDir() {
        boolean bl = this.mkdir();
        if (!bl) {
            throw new RuntimeException("Wasn't able to prepare LibDirectory!");
        }
    }
}

