/*
 * Decompiled with CFR 0.152.
 */
package com.cyr1en.javen;

import com.cyr1en.javen.Dependency;
import com.cyr1en.javen.LibDirectory;
import com.cyr1en.javen.PBStream;
import com.cyr1en.javen.Repositories;
import com.cyr1en.javen.Repository;
import com.cyr1en.javen.URLResolver;
import com.cyr1en.javen.util.JavenUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import us.eunoians.mcrpg.Logger;
import us.eunoians.mcrpg.LoggerFactory;

public class Javen {
    public static final Logger LOGGER;
    public static final Method ADD_URL_METHOD;
    private Repositories repositories = new Repositories();
    private URLResolver resolver = new URLResolver(this.repositories);
    private LibDirectory libsDir;
    private Map<Dependency, URLClassLoader> loadedDependency;
    private List<ClassLoader> classLoaders;

    public Javen(Path path) {
        this.libsDir = new LibDirectory(path.toString());
        this.loadedDependency = new LinkedHashMap<Dependency, URLClassLoader>();
        this.classLoaders = new ArrayList<ClassLoader>();
    }

    public static synchronized void loadDependencies(File[] fileArray) {
        for (File file : fileArray) {
            String string = file.getName();
            URLClassLoader uRLClassLoader = (URLClassLoader)Javen.class.getClassLoader();
            try {
                ADD_URL_METHOD.invoke((Object)uRLClassLoader, file.toURI().toURL());
                LOGGER.info("Successfully loaded: " + string);
            }
            catch (IllegalAccessException | InvocationTargetException | MalformedURLException exception) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized void loadDependencies() {
        this.downloadNeededDeps();
        try {
            for (Map.Entry<Dependency, File> entry : this.libsDir.listDepsToLoad(this.classLoaders.toArray(new ClassLoader[0])).entrySet()) {
                URL uRL = entry.getValue().toURI().toURL();
                URLClassLoader uRLClassLoader = (URLClassLoader)this.getClass().getClassLoader();
                ADD_URL_METHOD.invoke((Object)uRLClassLoader, uRL);
                this.loadedDependency.put(entry.getKey(), uRLClassLoader);
                LOGGER.info("Successfully loaded: " + entry.getKey().asJarName());
            }
        }
        catch (IllegalAccessException | InvocationTargetException | MalformedURLException exception) {
            exception.printStackTrace();
        }
    }

    public void downloadNeededDeps() {
        Map<Dependency, URL> map = this.getDepsToDownload();
        map.forEach((dependency, uRL) -> {
            if (this.libsDir.containsDiffVersionOf((Dependency)dependency)) {
                this.libsDir.deleteDifferentVersion((Dependency)dependency);
            }
            int n = JavenUtil.getFileSizeKB(uRL);
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
                 FileOutputStream fileOutputStream = new FileOutputStream(new File(this.libsDir, dependency.asJarName()));
                 ProgressBar progressBar = this.buildDownloadPB(dependency.asJarName(), n);){
                int n2;
                byte[] byArray = new byte[1024];
                while ((n2 = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                    fileOutputStream.write(byArray, 0, n2);
                    progressBar.step();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
    }

    public void unloadDependency(Dependency dependency) {
        if (!this.loadedDependency.containsKey(dependency)) {
            return;
        }
        try {
            this.loadedDependency.get(dependency).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Map<Dependency, URL> getDepsToDownload() {
        HashMap<Dependency, URL> hashMap = new HashMap<Dependency, URL>();
        JavenUtil.findAllRequestedDeps(this.classLoaders.toArray(new ClassLoader[0])).forEach(dependency -> {
            URL uRL;
            if (!this.libsDir.containsDependency((Dependency)dependency) && (uRL = this.resolver.resolve((Dependency)dependency)) != null) {
                hashMap.put((Dependency)dependency, uRL);
            }
        });
        return hashMap;
    }

    public void addRepository(Repository repository) {
        this.repositories.addRepo(repository);
    }

    public void addRepository(String string, String string2) {
        Repository repository = new Repository(string, string2);
        this.addRepository(repository);
    }

    public LibDirectory getLibsDir() {
        return this.libsDir;
    }

    public Repositories getRepositories() {
        return this.repositories;
    }

    public URLResolver getResolver() {
        return this.resolver;
    }

    public void addClassLoader(ClassLoader ... classLoaderArray) {
        this.classLoaders.addAll(Arrays.asList(classLoaderArray));
    }

    private ProgressBar buildDownloadPB(String string, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PBStream pBStream = new PBStream(byteArrayOutputStream);
        ProgressBarBuilder progressBarBuilder = new ProgressBarBuilder().setTaskName("Downloading " + string).setStyle(ProgressBarStyle.ASCII).setUpdateIntervalMillis(100).setInitialMax(n).setPrintStream(pBStream);
        return progressBarBuilder.build();
    }

    static {
        try {
            LOGGER = LoggerFactory.getLogger(Javen.class);
            ADD_URL_METHOD = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            ADD_URL_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }
}

