/*
 * Decompiled with CFR 0.152.
 */
package com.cyr1en.javen;

import java.util.Objects;

public class Dependency {
    private String groupId;
    private String artifactId;
    private String version;
    private String directURL;

    public Dependency(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public Dependency(String string, String string2, String string3, String string4) {
        this.groupId = string;
        this.artifactId = string2;
        this.version = string3;
        this.directURL = string4 == null ? "unresolved" : string4;
    }

    public String asURL() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.groupId.replaceAll("\\.", "/");
        String string2 = this.artifactId + "-" + this.version;
        stringBuilder.append(string).append("/");
        stringBuilder.append(this.artifactId).append("/");
        stringBuilder.append(this.version).append("/").append(string2).append(".jar");
        return stringBuilder.toString();
    }

    public String asJarName() {
        return this.getArtifactId() + "-" + this.getVersion() + ".jar";
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDirectURL() {
        return this.directURL;
    }

    public String getCanonicalName() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Dependency)) {
            return false;
        }
        Dependency dependency = (Dependency)object;
        return Objects.equals(this.groupId, dependency.groupId) && Objects.equals(this.artifactId, dependency.artifactId) && Objects.equals(this.version, dependency.version) && Objects.equals(this.directURL, dependency.directURL);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    public String toString() {
        return "Dependency{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", directURL='" + this.directURL + '\'' + '}';
    }
}

