/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.player;

import com.google.common.base.Preconditions;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lectern;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PlayerInsertLecternBookEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private boolean cancelled = false;
    private final Block block;
    private ItemStack book;

    @ApiStatus.Internal
    public PlayerInsertLecternBookEvent(Player player, Block block, ItemStack book) {
        super(player);
        this.block = block;
        this.book = book;
    }

    public Block getBlock() {
        return this.block;
    }

    public Lectern getLectern() {
        BlockState state = this.getBlock().getState();
        Preconditions.checkState((boolean)(state instanceof Lectern), (Object)"Block state of lectern block is no longer a lectern tile state!");
        return (Lectern)state;
    }

    public ItemStack getBook() {
        return this.book.clone();
    }

    public void setBook(ItemStack book) {
        Preconditions.checkArgument((book != null ? 1 : 0) != 0, (Object)"Cannot set book to null");
        this.book = book.clone();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

