/*
 * Decompiled with CFR 0.152.
 */
package me.ceze88.easygui.util;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import me.ceze88.easygui.compatibility.ServerVersion;
import me.ceze88.easygui.lib.nbtapi.NBT;
import me.ceze88.easygui.util.MiniMessagePlaceholder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AdventureUtils {
    private static Method messageMethod;
    private static Field contentField;

    public static String convertToJson(Component component) {
        return (String)GsonComponentSerializer.gson().serialize(component);
    }

    public static Component convertToShadedComponent(String json) {
        return GsonComponentSerializer.gson().deserialize((Object)json);
    }

    public static List<Component> convertToShadedComponent(List<String> json) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (String s : json) {
            components.add(AdventureUtils.convertToShadedComponent(s));
        }
        return components;
    }

    public static String extractChatMessage(AsyncChatEvent event) {
        try {
            Object component = messageMethod.invoke((Object)event, new Object[0]);
            if (contentField == null) {
                contentField = component.getClass().getDeclaredField("content");
                contentField.setAccessible(true);
            }
            return contentField.get(component).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Inventory createInventory(InventoryHolder owner, int rows, String title) {
        return Bukkit.createInventory((InventoryHolder)owner, (int)(rows * 9), (Component)AdventureUtils.formatComponent(title));
    }

    public static void sendMessage(Component message, CommandSender ... target) {
        for (CommandSender sender : target) {
            sender.sendMessage(message);
        }
    }

    public static void formatItemName(ItemStack item, String name) {
        AdventureUtils.formatItemName(item, AdventureUtils.formatComponent(name));
    }

    public static void formatItemName(ItemStack item, String name, MiniMessagePlaceholder ... placeholders) {
        AdventureUtils.formatItemName(item, AdventureUtils.formatComponent(name, placeholders));
    }

    public static void formatItemLore(ItemStack item, List<String> lore) {
        AdventureUtils.formatItemLore(item, lore.toArray(new String[0]));
    }

    public static void formatItemLore(ItemStack item, List<String> lore, MiniMessagePlaceholder ... placeholders) {
        AdventureUtils.formatItemLore(item, lore.toArray(new String[0]), placeholders);
    }

    public static void formatItemLore(ItemStack item, String ... lore) {
        AdventureUtils.formatItemLore(item, AdventureUtils.formatComponent(lore), new String[0]);
    }

    public static void formatItemLore(ItemStack item, List<Component> lore, String ... unused) {
        AdventureUtils.formatItemLore(item, lore.toArray(new Component[0]));
    }

    public static void formatItemLore(ItemStack item, String[] lore, MiniMessagePlaceholder ... placeholders) {
        LinkedList<Component> components = new LinkedList<Component>();
        for (String line : lore) {
            components.add(AdventureUtils.formatComponent(line, placeholders));
        }
        AdventureUtils.formatItemLore(item, components.toArray(new Component[0]));
    }

    public static void appendItemLore(ItemStack item, String ... lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (!meta.hasLore()) {
            AdventureUtils.formatItemLore(item, lore);
            return;
        }
        ArrayList<Component> newLore = new ArrayList<Component>(meta.lore());
        newLore.addAll(AdventureUtils.formatComponent(lore));
        AdventureUtils.formatItemLore(item, newLore.toArray(new Component[0]));
    }

    public static void formatItemName(ItemStack item, Component name) {
        AdventureUtils.setItemName(item, name);
    }

    public static void formatItemLore(ItemStack item, Component ... lore) {
        AdventureUtils.setItemLore(item, lore);
    }

    public static boolean isMiniMessageEnabled() {
        return true;
    }

    private static void setItemName(ItemStack item, Component name) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.displayName(name);
        item.setItemMeta(meta);
    }

    private static void setItemLore(ItemStack item, Component ... lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.lore(Arrays.asList(lore));
        item.setItemMeta(meta);
    }

    public static Component formatComponent(String text) {
        MiniMessage miniMessage = MiniMessage.builder().build();
        Component component = MiniMessage.miniMessage().deserialize((Object)AdventureUtils.replaceLegacy(text));
        if (!component.hasDecoration(TextDecoration.ITALIC)) {
            component = component.decoration(TextDecoration.ITALIC, false);
        }
        return component;
    }

    public static Component formatComponent(String text, MiniMessagePlaceholder ... placeholders) {
        MiniMessage miniMessage = MiniMessage.builder().editTags(builder -> Arrays.stream(placeholders).forEach(placeholder -> builder.resolver((TagResolver)Placeholder.parsed((String)placeholder.getPlaceholder(), (String)placeholder.getValue())))).build();
        Component component = miniMessage.deserialize((Object)AdventureUtils.replaceLegacy(text));
        if (!component.hasDecoration(TextDecoration.ITALIC)) {
            component = component.decoration(TextDecoration.ITALIC, false);
        }
        return component;
    }

    public static Component formatComponent(String text, List<MiniMessagePlaceholder> placeholders) {
        return AdventureUtils.formatComponent(text, placeholders.toArray(new MiniMessagePlaceholder[0]));
    }

    public static List<Component> formatComponent(List<String> list) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (String line : list) {
            result.add(AdventureUtils.formatComponent(line));
        }
        return result;
    }

    public static List<Component> formatComponent(String ... list) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (String line : list) {
            result.add(AdventureUtils.formatComponent(line));
        }
        return result;
    }

    public static List<Component> formatComponent(List<String> list, MiniMessagePlaceholder ... placeholders) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (String line : list) {
            result.add(AdventureUtils.formatComponent(line, placeholders));
        }
        return result;
    }

    public static List<Component> formatComponent(List<String> list, List<MiniMessagePlaceholder> placeholders) {
        return AdventureUtils.formatComponent(list, placeholders.toArray(new MiniMessagePlaceholder[0]));
    }

    public static String formatLegacy(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)LegacyComponentSerializer.legacyAmpersand().serialize(MiniMessage.miniMessage().deserialize((Object)AdventureUtils.replaceLegacy(text))));
    }

    public static List<String> formatLegacy(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : list) {
            result.add(AdventureUtils.formatLegacy(line));
        }
        return result;
    }

    public static List<String> formatLegacy(String ... list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : list) {
            result.add(AdventureUtils.formatLegacy(line));
        }
        return result;
    }

    public static String toLegacy(Component component) {
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    public static List<String> toLegacy(List<Component> components) {
        ArrayList<String> list = new ArrayList<String>();
        for (Component component : components) {
            list.add(AdventureUtils.toLegacy(component));
        }
        return list;
    }

    public static List<String> toLegacy(Component ... components) {
        ArrayList<String> list = new ArrayList<String>();
        for (Component component : components) {
            list.add(AdventureUtils.toLegacy(component));
        }
        return list;
    }

    public static String replaceLegacy(String legacy) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < legacy.length(); ++i) {
            char current = legacy.charAt(i);
            char next = legacy.charAt(i == legacy.length() - 1 ? i : i + 1);
            if (current == '\u00a7' || current == '&') {
                if (next == 'x' && legacy.length() > i + 13) {
                    builder.append("<color:#");
                    builder.append(legacy.charAt(i + 3));
                    builder.append(legacy.charAt(i + 5));
                    builder.append(legacy.charAt(i + 7));
                    builder.append(legacy.charAt(i + 9));
                    builder.append(legacy.charAt(i + 11));
                    builder.append(legacy.charAt(i + 13));
                    builder.append(">");
                    i += 13;
                    continue;
                }
                String color = AdventureUtils.getColor(next);
                if (color == null) {
                    builder.append(current);
                    continue;
                }
                builder.append(color);
                ++i;
                continue;
            }
            builder.append(current);
        }
        return builder.toString();
    }

    public static String getColor(char c) {
        ChatColor color = ChatColor.getByChar((char)c);
        if (color == null) {
            return null;
        }
        switch (c) {
            case '0': {
                return "<black>";
            }
            case '1': {
                return "<dark_blue>";
            }
            case '2': {
                return "<dark_green>";
            }
            case '3': {
                return "<dark_aqua>";
            }
            case '4': {
                return "<dark_red>";
            }
            case '5': {
                return "<dark_purple>";
            }
            case '6': {
                return "<gold>";
            }
            case '7': {
                return "<gray>";
            }
            case '8': {
                return "<dark_gray>";
            }
            case '9': {
                return "<blue>";
            }
            case 'a': {
                return "<green>";
            }
            case 'b': {
                return "<aqua>";
            }
            case 'c': {
                return "<red>";
            }
            case 'd': {
                return "<light_purple>";
            }
            case 'e': {
                return "<yellow>";
            }
            case 'f': {
                return "<white>";
            }
            case 'k': {
                return "<obfuscated>";
            }
            case 'l': {
                return "<b>";
            }
            case 'm': {
                return "<st>";
            }
            case 'n': {
                return "<u>";
            }
            case 'o': {
                return "<i>";
            }
            case 'r': {
                return "<reset>";
            }
        }
        return null;
    }

    public static String clear(String msg) {
        msg = msg.replaceAll("&[0-9abcdefklmnor]", "");
        msg = msg.replaceAll("\u00a7[0-9abcdefklmnor]", "");
        msg = msg.replaceAll("&#[0-9a-fA-F]{6}", "");
        return PlainTextComponentSerializer.plainText().serialize(MiniMessage.miniMessage().deserialize((Object)msg));
    }

    public static String clear(Component component) {
        return PlainTextComponentSerializer.plainText().serialize(component);
    }

    public static Component formatPlaceholder(Component message, MiniMessagePlaceholder ... placeholder) {
        return message.replaceText(builder -> {
            for (MiniMessagePlaceholder place : placeholder) {
                builder.matchLiteral(place.getPlaceholder()).replacement(place.getValue());
            }
        });
    }

    public static void addGlow(ItemStack itemStack) {
        NBT.modify(itemStack, readWriteItemNBT -> {
            if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_20_5)) {
                readWriteItemNBT.mergeCompound(NBT.parseNBT("{minecraft:enchantments:[]}"));
            } else {
                readWriteItemNBT.mergeCompound(NBT.parseNBT("{ench:[]}"));
            }
        });
    }

    static {
        try {
            messageMethod = AsyncChatEvent.class.getMethod("message", new Class[0]);
            messageMethod.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

