/*
 * Decompiled with CFR 0.152.
 */
package me.ceze88.easygui.gui;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import me.ceze88.easygui.EasyGUI;
import me.ceze88.easygui.util.AdventureUtils;
import me.ceze88.easygui.util.MiniMessagePlaceholder;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemStackBuilder {
    private final ItemStack itemStack = new ItemStack(Material.AIR);

    public ItemStackBuilder setType(Material material) {
        this.itemStack.setType(material);
        return this;
    }

    public ItemStackBuilder setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    public ItemStackBuilder setDisplayName(String displayName) {
        AdventureUtils.formatItemName(this.itemStack, displayName);
        return this;
    }

    public ItemStackBuilder setDisplayName(String displayName, MiniMessagePlaceholder ... placeholders) {
        AdventureUtils.formatItemName(this.itemStack, displayName, placeholders);
        return this;
    }

    public ItemStackBuilder setLore(LoreBuilder loreBuilder) {
        AdventureUtils.formatItemLore(this.itemStack, loreBuilder.lore);
        return this;
    }

    public ItemStackBuilder setLore(String ... lore) {
        AdventureUtils.formatItemLore(this.itemStack, lore);
        return this;
    }

    public ItemStackBuilder setLore(List<String> lore, MiniMessagePlaceholder ... placeholders) {
        AdventureUtils.formatItemLore(this.itemStack, lore, placeholders);
        return this;
    }

    public ItemStackBuilder setModelData(int modelData) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.setCustomModelData(Integer.valueOf(modelData));
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }

    public ItemStackBuilder addGlow() {
        AdventureUtils.addGlow(this.itemStack);
        return this;
    }

    public ItemStackBuilder modify(Consumer<ItemStack> consumer) {
        consumer.accept(this.itemStack);
        return this;
    }

    public ItemStack build() {
        if (this.itemStack.getType() == Material.AIR) {
            EasyGUI.getPlugin().getLogger().warning("ItemStack is AIR in ItemStackBuilder. Please set a material before building.");
            new Throwable().printStackTrace();
        }
        return this.itemStack;
    }

    public static class LoreBuilder {
        private List<String> lore = new LinkedList<String>();

        public LoreBuilder addLine(String line) {
            this.lore.add(line);
            return this;
        }

        public LoreBuilder addLineIf(boolean condition, String line) {
            if (condition) {
                this.lore.add(line);
            }
            return this;
        }
    }
}

