/*
 * Decompiled with CFR 0.152.
 */
package me.ceze88.easygui.gui;

import java.util.function.Consumer;
import lombok.Generated;
import me.ceze88.easygui.gui.ClickConsumer;
import me.ceze88.easygui.gui.GuiHolder;
import me.ceze88.easygui.gui.ItemStackBuilder;
import me.ceze88.easygui.gui.State;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class GuiItem {
    private ClickConsumer<InventoryClickEvent, GuiHolder, GuiItem> clickConsumer;
    private Consumer<ItemStackBuilder> constructItem;
    private State state = State.STANDBY;
    private ItemStack item;
    private int x;
    private int y;

    public GuiItem(ItemStack item, int x, int y) {
        this.item = item;
        this.clickConsumer = null;
        this.x = x;
        this.y = y;
    }

    public GuiItem(ItemStack item, ClickConsumer<InventoryClickEvent, GuiHolder, GuiItem> clickConsumer, int x, int y) {
        this.item = item;
        this.clickConsumer = clickConsumer;
        this.x = x;
        this.y = y;
    }

    public GuiItem(Consumer<ItemStackBuilder> itemStackBuilder, ClickConsumer<InventoryClickEvent, GuiHolder, GuiItem> clickConsumer, int x, int y) {
        ItemStackBuilder builder = new ItemStackBuilder();
        this.constructItem = itemStackBuilder;
        this.clickConsumer = clickConsumer;
        this.constructItem.accept(builder);
        this.item = builder.build();
        this.x = x;
        this.y = y;
    }

    public void update() {
        if (this.constructItem != null) {
            this.state = State.UPDATE;
        }
    }

    public void setX(int x) {
        this.x = x;
        this.state = State.UPDATE;
    }

    public void setY(int y) {
        this.y = y;
        this.state = State.UPDATE;
    }

    void onClick(InventoryClickEvent event, GuiHolder gui, GuiItem guiItem) {
        if (this.clickConsumer != null) {
            this.clickConsumer.accept(event, gui, guiItem);
        }
    }

    boolean shouldUpdate() {
        return this.state == State.UPDATE;
    }

    ItemStack updateItem() {
        if (this.constructItem != null) {
            ItemStackBuilder builder = new ItemStackBuilder();
            this.constructItem.accept(builder);
            this.item = builder.build();
            this.state = State.STANDBY;
            return this.item;
        }
        return this.getItem();
    }

    @Generated
    public ItemStack getItem() {
        return this.item;
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public int getY() {
        return this.y;
    }
}

