/*
 * Decompiled with CFR 0.152.
 */
package me.ceze88.easygui.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.Generated;
import me.ceze88.easygui.EasyGUI;
import me.ceze88.easygui.gui.ClickConsumer;
import me.ceze88.easygui.gui.GuiHolder;
import me.ceze88.easygui.gui.GuiItem;
import me.ceze88.easygui.gui.GuiManager;
import me.ceze88.easygui.gui.ItemStackBuilder;
import me.ceze88.easygui.util.AdventureUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Gui
implements GuiHolder {
    private static final UUID UID = UUID.randomUUID();
    private final int rows;
    private final Inventory inventory;
    private final List<GuiItem> items = new ArrayList<GuiItem>();
    private Consumer<InventoryClickEvent> onGlobalClick;
    private Consumer<InventoryClickEvent> onTopClick;
    private Consumer<InventoryClickEvent> onBottomClick;
    private Consumer<InventoryClickEvent> onGlobalDrag;
    private Consumer<InventoryClickEvent> onTopDrag;
    private Consumer<InventoryClickEvent> onBottomDrag;
    private Consumer<InventoryCloseEvent> onClose;
    private final List<Player> openers = new ArrayList<Player>();
    private boolean cancelClick = true;
    private Gui previusGui = null;

    public Gui(String name, int rows) {
        this.rows = rows;
        this.inventory = AdventureUtils.createInventory(this, rows, name);
    }

    public Gui setPreviusGui(Gui gui) {
        this.previusGui = gui;
        ItemStack back = new ItemStack(Material.ARROW);
        AdventureUtils.formatItemName(back, "\u00a7cVissza");
        this.addItem(new GuiItem(back, (event, gui1, guiItem) -> {
            if (this.previusGui != null) {
                this.previusGui.reDrawIfNeeded();
                this.previusGui.show((Player)event.getWhoClicked());
            }
        }, 0, this.rows - 1));
        return this;
    }

    private void reDrawIfNeeded() {
        boolean needsRedraw = false;
        for (GuiItem item : this.items) {
            if (!item.shouldUpdate()) continue;
            needsRedraw = true;
            item.updateItem();
        }
        if (needsRedraw) {
            this.refresh();
        }
    }

    public Gui addItem(GuiItem item) {
        if (item.getX() == -1 || item.getY() == -1) {
            EasyGUI.getPlugin().getLogger().warning("Tried to add an item with x or y set to -1, ignoring it. These values are reserved for PaginatedGui");
            return this;
        }
        this.items.removeIf(i -> i.getX() == item.getX() && i.getY() == item.getY());
        this.items.add(item);
        this.inventory.setItem(item.getX() + item.getY() * 9, item.getItem());
        return this;
    }

    public Gui addItem(ItemStack item, ClickConsumer<InventoryClickEvent, GuiHolder, GuiItem> event, int x, int y) {
        return this.addItem(new GuiItem(item, event, x, y));
    }

    public Gui addItem(ItemStack item, int x, int y) {
        return this.addItem(new GuiItem(item, x, y));
    }

    public Gui addItem(Consumer<ItemStackBuilder> itemStackBuilder, ClickConsumer<InventoryClickEvent, GuiHolder, GuiItem> event, int x, int y) {
        return this.addItem(new GuiItem(itemStackBuilder, event, x, y));
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean clear) {
        if (clear) {
            this.inventory.clear();
            for (GuiItem item : this.items) {
                if (item.shouldUpdate()) {
                    item.updateItem();
                }
                this.inventory.setItem(item.getX() + item.getY() * 9, item.getItem());
            }
        } else {
            for (GuiItem item : this.items) {
                if (!item.shouldUpdate()) continue;
                item.updateItem();
                this.inventory.setItem(item.getX() + item.getY() * 9, item.getItem());
            }
        }
    }

    public void reopen(Player player) {
        this.show(player);
    }

    public void reopenAll() {
        for (Player player : this.openers) {
            this.show(player);
        }
    }

    public Gui show(Player player) {
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask(EasyGUI.getPlugin(), () -> this.show(player));
            return this;
        }
        player.openInventory(this.inventory);
        if (!this.openers.contains(player)) {
            this.openers.add(player);
        }
        GuiManager.markAsOpen(this);
        return this;
    }

    public Gui close(Player player) {
        player.closeInventory();
        this.openers.remove(player);
        if (this.openers.isEmpty()) {
            GuiManager.markAsClosed(this);
        }
        return this;
    }

    public Gui closeAll() {
        for (Player player : this.openers) {
            player.closeInventory();
        }
        this.openers.clear();
        GuiManager.markAsClosed(this);
        return this;
    }

    public List<Player> getOpeners() {
        return Collections.unmodifiableList(this.openers);
    }

    public Gui setCancelClick(boolean cancelClick) {
        this.cancelClick = cancelClick;
        return this;
    }

    @Override
    public boolean cancelClick() {
        return this.cancelClick;
    }

    @Override
    @Nullable
    public GuiItem getItem(int slot) {
        int x = slot % 9;
        int y = slot / 9;
        for (GuiItem item : this.items) {
            if (item.getX() != x || item.getY() != y) continue;
            return item;
        }
        return null;
    }

    @Override
    public Gui setOnGlobalClick(Consumer<InventoryClickEvent> onGlobalClick) {
        this.onGlobalClick = onGlobalClick;
        return this;
    }

    @Override
    public Gui setOnTopClick(Consumer<InventoryClickEvent> onTopClick) {
        this.onTopClick = onTopClick;
        return this;
    }

    @Override
    public Gui setOnBottomClick(Consumer<InventoryClickEvent> onBottomClick) {
        this.onBottomClick = onBottomClick;
        return this;
    }

    @Override
    public Gui setOnGlobalDrag(Consumer<InventoryClickEvent> onGlobalDrag) {
        this.onGlobalDrag = onGlobalDrag;
        return this;
    }

    @Override
    public Gui setOnTopDrag(Consumer<InventoryClickEvent> onTopDrag) {
        this.onTopDrag = onTopDrag;
        return this;
    }

    @Override
    public Gui setOnBottomDrag(Consumer<InventoryClickEvent> onBottomDrag) {
        this.onBottomDrag = onBottomDrag;
        return this;
    }

    @Override
    public Gui setOnClose(Consumer<InventoryCloseEvent> onClose) {
        this.onClose = onClose;
        return this;
    }

    public Gui fetchFills(ConfigurationSection config) {
        String fillBottom;
        String fillBorder;
        String fillEmpty = config.getString("Fill Empty");
        if (fillEmpty != null) {
            ItemStack fillEmptyItem = new ItemStack(Material.valueOf((String)fillEmpty));
            this.fillEmpty(fillEmptyItem);
        }
        if ((fillBorder = config.getString("Fill Border")) != null) {
            ItemStack fillBorderItem = new ItemStack(Material.valueOf((String)fillBorder));
            this.fillBorder(fillBorderItem);
        }
        if ((fillBottom = config.getString("Fill Bottom")) != null) {
            ItemStack fillBottomItem = new ItemStack(Material.valueOf((String)fillBottom));
            this.fillBottom(fillBottomItem);
        }
        return this;
    }

    public Gui fillEmpty(ItemStack item) {
        AdventureUtils.formatItemName(item, " ");
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.addItem(new GuiItem(item, i % 9, i / 9));
        }
        return this;
    }

    public Gui fillEmpty(Material material) {
        return this.fillEmpty(new ItemStack(material));
    }

    public Gui fillBorder(ItemStack item) {
        int i;
        AdventureUtils.formatItemName(item, " ");
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, item);
            this.addItem(new GuiItem(item, i, 0));
        }
        for (i = 1; i < this.inventory.getSize() / 9 - 1; ++i) {
            this.addItem(new GuiItem(item, 0, i));
            this.addItem(new GuiItem(item, 8, i));
        }
        return this;
    }

    public Gui fillBorder(Material material) {
        return this.fillBorder(new ItemStack(material));
    }

    public Gui fillBottom(ItemStack item) {
        AdventureUtils.formatItemName(item, " ");
        for (int i = this.inventory.getSize() - 9; i < this.inventory.getSize(); ++i) {
            this.addItem(new GuiItem(item, i % 9, i / 9));
        }
        return this;
    }

    public Gui fillBottom(Material material) {
        return this.fillBottom(new ItemStack(material));
    }

    @Override
    public void onClose(Player player) {
        this.openers.remove(player);
        if (this.openers.isEmpty()) {
            GuiManager.markAsClosed(this);
        }
    }

    @Override
    public void updateItem(GuiItem item) {
        this.inventory.setItem(item.getX() + item.getY() * 9, item.updateItem());
    }

    public UUID getUID() {
        return UID;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Gui gui = (Gui)obj;
        return UID.equals(gui.getUID());
    }

    public int hashCode() {
        return UID.hashCode();
    }

    @Override
    @Generated
    public Consumer<InventoryClickEvent> getOnGlobalClick() {
        return this.onGlobalClick;
    }

    @Override
    @Generated
    public Consumer<InventoryClickEvent> getOnTopClick() {
        return this.onTopClick;
    }

    @Override
    @Generated
    public Consumer<InventoryClickEvent> getOnBottomClick() {
        return this.onBottomClick;
    }

    @Override
    @Generated
    public Consumer<InventoryClickEvent> getOnGlobalDrag() {
        return this.onGlobalDrag;
    }

    @Override
    @Generated
    public Consumer<InventoryClickEvent> getOnTopDrag() {
        return this.onTopDrag;
    }

    @Override
    @Generated
    public Consumer<InventoryClickEvent> getOnBottomDrag() {
        return this.onBottomDrag;
    }

    @Override
    @Generated
    public Consumer<InventoryCloseEvent> getOnClose() {
        return this.onClose;
    }
}

