/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.serverlib;

import java.util.ArrayList;
import java.util.Collection;
import org.incendo.serverlib.Check;
import org.incendo.serverlib.forks.Akarin;
import org.incendo.serverlib.forks.KibblePatcher;
import org.incendo.serverlib.forks.Sugarcane;
import org.incendo.serverlib.forks.Yatopia;
import org.incendo.serverlib.hybrids.Fabric;
import org.incendo.serverlib.hybrids.Forge;
import org.incendo.serverlib.util.JavaVersionCheck;

public final class ServerLib {
    private final Collection<Check> checks;

    private ServerLib(Collection<Check> checks) {
        this.checks = checks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void checkUnsafeForks() {
        ServerLib serverLib = ServerLib.builder().withCheck(new Akarin()).withCheck(new KibblePatcher()).withCheck(new Yatopia()).withCheck(new Sugarcane()).withCheck(new Fabric()).withCheck(new Forge()).build();
        serverLib.runChecks();
    }

    @Deprecated
    public static void checkJavaLTS() {
        JavaVersionCheck.checkJavaSixteen();
    }

    public static void isJavaSixteen() {
        JavaVersionCheck.checkJavaSixteen();
    }

    @Deprecated
    public static void checkJavaMinor() {
        JavaVersionCheck.checkJavaFifteen();
    }

    public static void isJavaFifteen() {
        JavaVersionCheck.checkJavaFifteen();
    }

    public void runChecks() {
        for (Check check : this.checks) {
            if (!check.shouldFlag()) continue;
            check.printExplanation();
        }
    }

    public static final class Builder {
        private final Collection<Check> checks = new ArrayList<Check>();

        private Builder(Collection<Check> checks) {
            this.checks.addAll(checks);
        }

        private Builder() {
        }

        public Builder withCheck(Check check) {
            ArrayList<Check> checks = new ArrayList<Check>(this.checks);
            checks.add(check);
            return new Builder(checks);
        }

        public ServerLib build() {
            return new ServerLib(this.checks);
        }
    }
}

