/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.player;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.SkinParts;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.MainHand;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PlayerClientOptionsChangeEvent
extends PlayerEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final String locale;
    private final int viewDistance;
    private final ClientOption.ChatVisibility chatVisibility;
    private final boolean chatColors;
    private final SkinParts skinparts;
    private final MainHand mainHand;
    private final boolean allowsServerListings;
    private final boolean textFilteringEnabled;
    private final ClientOption.ParticleVisibility particleVisibility;

    @Deprecated
    public PlayerClientOptionsChangeEvent(Player player, String locale, int viewDistance, ClientOption.ChatVisibility chatVisibility, boolean chatColors, SkinParts skinParts, MainHand mainHand) {
        super(player);
        this.locale = locale;
        this.viewDistance = viewDistance;
        this.chatVisibility = chatVisibility;
        this.chatColors = chatColors;
        this.skinparts = skinParts;
        this.mainHand = mainHand;
        this.allowsServerListings = false;
        this.textFilteringEnabled = false;
        this.particleVisibility = ClientOption.ParticleVisibility.ALL;
    }

    @ApiStatus.Internal
    public PlayerClientOptionsChangeEvent(Player player, Map<ClientOption<?>, ?> options) {
        super(player);
        this.locale = (String)options.get(ClientOption.LOCALE);
        this.viewDistance = (Integer)options.get(ClientOption.VIEW_DISTANCE);
        this.chatVisibility = (ClientOption.ChatVisibility)((Object)options.get(ClientOption.CHAT_VISIBILITY));
        this.chatColors = (Boolean)options.get(ClientOption.CHAT_COLORS_ENABLED);
        this.skinparts = (SkinParts)options.get(ClientOption.SKIN_PARTS);
        this.mainHand = (MainHand)((Object)options.get(ClientOption.MAIN_HAND));
        this.allowsServerListings = (Boolean)options.get(ClientOption.ALLOW_SERVER_LISTINGS);
        this.textFilteringEnabled = (Boolean)options.get(ClientOption.TEXT_FILTERING_ENABLED);
        this.particleVisibility = (ClientOption.ParticleVisibility)((Object)options.get(ClientOption.PARTICLE_VISIBILITY));
    }

    public String getLocale() {
        return this.locale;
    }

    public boolean hasLocaleChanged() {
        return !this.locale.equals(this.player.getClientOption(ClientOption.LOCALE));
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public boolean hasViewDistanceChanged() {
        return this.viewDistance != this.player.getClientOption(ClientOption.VIEW_DISTANCE);
    }

    public ClientOption.ChatVisibility getChatVisibility() {
        return this.chatVisibility;
    }

    public boolean hasChatVisibilityChanged() {
        return this.chatVisibility != this.player.getClientOption(ClientOption.CHAT_VISIBILITY);
    }

    public boolean hasChatColorsEnabled() {
        return this.chatColors;
    }

    public boolean hasChatColorsEnabledChanged() {
        return this.chatColors != this.player.getClientOption(ClientOption.CHAT_COLORS_ENABLED);
    }

    public SkinParts getSkinParts() {
        return this.skinparts;
    }

    public boolean hasSkinPartsChanged() {
        return this.skinparts.getRaw() != this.player.getClientOption(ClientOption.SKIN_PARTS).getRaw();
    }

    public MainHand getMainHand() {
        return this.mainHand;
    }

    public boolean hasMainHandChanged() {
        return this.mainHand != this.player.getClientOption(ClientOption.MAIN_HAND);
    }

    public boolean hasTextFilteringEnabled() {
        return this.textFilteringEnabled;
    }

    public boolean hasTextFilteringChanged() {
        return this.textFilteringEnabled != this.player.getClientOption(ClientOption.TEXT_FILTERING_ENABLED);
    }

    public boolean allowsServerListings() {
        return this.allowsServerListings;
    }

    public boolean hasAllowServerListingsChanged() {
        return this.allowsServerListings != this.player.getClientOption(ClientOption.ALLOW_SERVER_LISTINGS);
    }

    public ClientOption.ParticleVisibility getParticleVisibility() {
        return this.particleVisibility;
    }

    public boolean hasParticleVisibilityChanged() {
        return this.particleVisibility != this.player.getClientOption(ClientOption.PARTICLE_VISIBILITY);
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

