/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.executor;

import com.destroystokyo.paper.util.SneakyThrow;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.Internal
public class MethodHandleEventExecutor
implements EventExecutor {
    private final Class<? extends Event> eventClass;
    private final MethodHandle handle;
    private final @Nullable Method method;

    public MethodHandleEventExecutor(Class<? extends Event> eventClass, MethodHandle handle) {
        this.eventClass = eventClass;
        this.handle = handle;
        this.method = null;
    }

    public MethodHandleEventExecutor(Class<? extends Event> eventClass, Method m) {
        this.eventClass = eventClass;
        try {
            m.setAccessible(true);
            this.handle = MethodHandles.lookup().unreflect(m);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("Unable to set accessible", e);
        }
        this.method = m;
    }

    @Override
    public void execute(Listener listener, Event event) throws EventException {
        if (!this.eventClass.isInstance(event)) {
            return;
        }
        try {
            this.handle.invoke(listener, event);
        }
        catch (Throwable t) {
            SneakyThrow.sneaky(t);
        }
    }

    public String toString() {
        return "MethodHandleEventExecutor['" + String.valueOf(this.method) + "']";
    }
}

