/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.utils.worldedit;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.util.nbt.TagStringIO;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public final class BaseBlockParser {
    private BaseBlockParser() {
    }

    public static BaseBlock asBaseBlock(String blockString) throws IOException {
        int nbtIndex = blockString.indexOf("{");
        if (nbtIndex == -1) {
            return BlockState.get((String)blockString).toBaseBlock();
        }
        BlockState blockState = BlockState.get((String)blockString.substring(0, nbtIndex));
        return blockState.toBaseBlock(TagStringIO.get().asCompound(blockString.substring(nbtIndex)));
    }

    public static BaseBlock parseInput(String input) throws InputParseException {
        ParserContext parserContext = new ParserContext();
        parserContext.setActor(BukkitAdapter.adapt((CommandSender)Bukkit.getConsoleSender()));
        return (BaseBlock)WorldEdit.getInstance().getBlockFactory().parseFromInput(input, parserContext);
    }
}

