/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.utils.metrics;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Scanner;
import me.catalysmrl.catamines.utils.message.Messages;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker
implements Listener {
    private final int RESOURCE_ID = 96457;
    private final JavaPlugin plugin;
    private final String pluginVersion;
    private String spigotVersion;
    private boolean updateAvailable;

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        this.pluginVersion = plugin.getDescription().getVersion();
    }

    public void fetch() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (InputStream is = new URL("https://api.spigotmc.org/legacy/update.php?resource=96457").openStream();
                 Scanner scanner = new Scanner(is);){
                if (scanner.hasNext()) {
                    this.spigotVersion = scanner.next();
                }
            }
            catch (IOException exception) {
                this.plugin.getLogger().warning("Failed to fetch for updates on spigot.");
                return;
            }
            if (this.spigotVersion == null || this.spigotVersion.isEmpty()) {
                return;
            }
            this.updateAvailable = this.spigotIsNewer();
            if (!this.updateAvailable) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                this.plugin.getLogger().info("A new version of CataMines is available (v" + this.spigotVersion + ") at:");
                this.plugin.getLogger().info("https://www.spigotmc.org/resources/96457/");
                Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            });
        });
    }

    private boolean spigotIsNewer() {
        int[] spV;
        if (this.spigotVersion == null || this.spigotVersion.isEmpty()) {
            return false;
        }
        int[] plV = this.toReadable(this.pluginVersion);
        if (plV[0] < (spV = this.toReadable(this.spigotVersion))[0]) {
            return true;
        }
        if (plV[1] < spV[1]) {
            return true;
        }
        return plV[2] < spV[2];
    }

    private int[] toReadable(String version) {
        return Arrays.stream(version.split("\\.")).mapToInt(Integer::parseInt).toArray();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(PlayerJoinEvent event) {
        if (event.getPlayer().isOp()) {
            Messages.send((CommandSender)event.getPlayer(), "An update for &bCata&aMines &6(v" + this.spigotVersion + ")", "&7is available at: &dhttps://spigotmc.org/resources/96457/");
        }
    }
}

