/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.utils.message;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class Messages {
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("&#([0-9a-fA-F]{6})");
    public static String PREFIX = "&6[&bCata&aMines&6]";

    public static void send(CommandSender sender, String message) {
        sender.sendMessage(Messages.colorize(PREFIX + "&7 " + message));
    }

    public static void send(CommandSender sender, String ... messages) {
        if (messages.length == 0) {
            return;
        }
        Messages.send(sender, String.join((CharSequence)"\n", messages));
    }

    public static void sendColorized(CommandSender sender, String message) {
        sender.sendMessage(Messages.colorize(message));
    }

    public static String colorize(String string) {
        if (string == null) {
            return "null";
        }
        Matcher matcher = HEX_COLOR_PATTERN.matcher(string);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            StringBuilder replacement = new StringBuilder(14).append("&x");
            for (char character : matcher.group(1).toCharArray()) {
                replacement.append('&').append(character);
            }
            matcher.appendReplacement(sb, replacement.toString());
        }
        matcher.appendTail(sb);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)sb.toString());
    }
}

