/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.utils.message;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import me.catalysmrl.catamines.CataMines;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LangSystem {
    private final CataMines plugin;
    private final Path langDirectory;
    private final Path defaultDirectory;
    private final Path customDirectory;
    private Locale locale;
    private static FileConfiguration langFile;

    public LangSystem(CataMines plugin) {
        this.plugin = plugin;
        this.langDirectory = plugin.getDataFolder().toPath().resolve("lang");
        this.defaultDirectory = this.langDirectory.resolve("default");
        this.customDirectory = this.langDirectory.resolve("custom");
        this.reloadLang();
    }

    public static String getTranslatedMessage(String key) {
        if (langFile == null) {
            return "Failed to load language file";
        }
        return langFile.getString(key, "Missing " + key);
    }

    public static List<String> getTranslatedList(String key) {
        if (langFile == null) {
            return Collections.singletonList("Failed to load language file");
        }
        return langFile.contains(key) ? langFile.getStringList(key) : Collections.singletonList("Missing " + key);
    }

    public void reloadLang() {
        this.locale = new Locale(this.plugin.getConfig().getString("language", "en"));
        try {
            LangSystem.createDirectoriesIfNotExists(this.langDirectory);
            LangSystem.createDirectoriesIfNotExists(this.defaultDirectory);
            LangSystem.createDirectoriesIfNotExists(this.customDirectory);
            this.copyResourceToDisk("Lang_en.yml");
            this.copyResourceToDisk("Lang_de.yml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        langFile = this.resolveLangFile();
    }

    private void copyResourceToDisk(String resourceName) throws IOException {
        try (InputStream is = this.plugin.getResource("i18n/" + resourceName);){
            if (is == null) {
                this.plugin.getLogger().severe("Could not find resource " + resourceName);
                return;
            }
            Files.copy(is, this.defaultDirectory.resolve(resourceName), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private FileConfiguration resolveLangFile() {
        String langFileName = "Lang_" + this.locale.toLanguageTag() + ".yml";
        Path customFile = this.customDirectory.resolve(langFileName);
        if (Files.exists(customFile, new LinkOption[0])) {
            return YamlConfiguration.loadConfiguration((File)customFile.toFile());
        }
        Path defaultFile = this.defaultDirectory.resolve(langFileName);
        if (Files.exists(defaultFile, new LinkOption[0])) {
            return YamlConfiguration.loadConfiguration((File)defaultFile.toFile());
        }
        this.plugin.getLogger().severe("Failed to load language file " + String.valueOf(defaultFile));
        return null;
    }

    private static void createDirectoriesIfNotExists(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && (Files.isDirectory(path, new LinkOption[0]) || Files.isSymbolicLink(path))) {
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }
}

