/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.mine.components.region.impl;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.ConvexPolyhedralRegion;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.CylinderRegion;
import com.sk89q.worldedit.regions.EllipsoidRegion;
import com.sk89q.worldedit.regions.NullRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.world.World;
import java.util.List;
import me.catalysmrl.catamines.api.serialization.DeserializationException;
import me.catalysmrl.catamines.mine.components.composition.CataMineComposition;
import me.catalysmrl.catamines.mine.components.region.AbstractCataMineRegion;
import me.catalysmrl.catamines.mine.components.region.CataMineRegion;
import me.catalysmrl.catamines.utils.worldedit.VectorParser;
import me.catalysmrl.catamines.utils.worldedit.WorldEditUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public class SelectionRegion
extends AbstractCataMineRegion {
    private SelectionType selectionType;
    private Region region;

    public SelectionRegion(String name, RegionSelector selector) {
        super(name);
        this.defineRegion(selector);
    }

    public SelectionRegion(String name, SelectionType selectionType, Region region) {
        super(name);
        this.selectionType = selectionType;
        this.region = region;
    }

    @Override
    public void fill() {
        this.getCompositionManager().getUpcoming().ifPresent(composition -> WorldEditUtils.pasteRegion(this.region, (Pattern)composition.getRandomPattern()));
        this.getCompositionManager().next();
    }

    public void defineRegion(RegionSelector selector) throws IncompleteRegionException {
        this.selectionType = SelectionType.getType(selector.getTypeName());
        this.region = selector.getRegion().clone();
    }

    @Override
    public CataMineRegion.RegionType getType() {
        return CataMineRegion.RegionType.SELECTION;
    }

    @Override
    public long getVolume() {
        return this.region.getVolume();
    }

    @Override
    public void serialize(ConfigurationSection section) {
        super.serialize(section);
        section.set("world", (Object)(this.region.getWorld() == null ? "null" : this.region.getWorld().getName()));
        section.set("selection-type", (Object)this.selectionType.toString());
        this.serializeRegion(section.createSection("selection"));
        this.serializeCompositions(section.createSection("compositions"));
    }

    public void serializeRegion(ConfigurationSection section) {
        switch (this.selectionType.ordinal()) {
            case 1: {
                section.set("min", (Object)this.region.getMinimumPoint().toParserString());
                section.set("max", (Object)this.region.getMaximumPoint().toParserString());
                break;
            }
            case 2: {
                CylinderRegion cylinderRegion = (CylinderRegion)this.region;
                section.set("center", (Object)cylinderRegion.getCenter().toParserString());
                section.set("radius", (Object)cylinderRegion.getRadius().toParserString());
                section.set("minY", (Object)cylinderRegion.getMinimumY());
                section.set("maxY", (Object)cylinderRegion.getMaximumY());
                break;
            }
            case 3: 
            case 4: {
                EllipsoidRegion ellipsoidRegion = (EllipsoidRegion)this.region;
                section.set("center", (Object)ellipsoidRegion.getCenter().toParserString());
                section.set("radius", (Object)ellipsoidRegion.getRadius().toParserString());
                break;
            }
            case 5: {
                Polygonal2DRegion polygonal2DRegion = (Polygonal2DRegion)this.region;
                List<String> points = polygonal2DRegion.getPoints().stream().map(BlockVector2::toParserString).toList();
                section.set("points", points);
                section.set("minY", (Object)polygonal2DRegion.getMinimumY());
                section.set("maxY", (Object)polygonal2DRegion.getMinimumY());
                break;
            }
            case 6: {
                ConvexPolyhedralRegion convexPolyhedralRegion = (ConvexPolyhedralRegion)this.region;
                List<String> vertices = convexPolyhedralRegion.getVertices().stream().map(BlockVector3::toParserString).toList();
                section.set("vertices", vertices);
                break;
            }
            default: {
                section.set("parameters", (Object)"undefined");
            }
        }
    }

    public static SelectionRegion deserialize(ConfigurationSection section) throws DeserializationException {
        String name = section.getString("name");
        if (name == null) {
            throw new DeserializationException("No name specified");
        }
        double chance = section.getDouble("chance", 0.0);
        String worldName = section.getString("world");
        if (worldName == null) {
            throw new DeserializationException("No world specified in region " + name);
        }
        org.bukkit.World bukkitWorld = Bukkit.getWorld((String)worldName);
        if (bukkitWorld == null) {
            throw new DeserializationException("World " + worldName + " not found in region " + name);
        }
        World worldEditWorld = BukkitAdapter.adapt((org.bukkit.World)bukkitWorld);
        SelectionType selectionType = SelectionType.valueOf(section.getString("selection-type"));
        if (selectionType == SelectionType.NONE) {
            throw new DeserializationException("Invalid selection type in region " + name);
        }
        ConfigurationSection selectionSection = section.getConfigurationSection("selection");
        if (selectionSection == null) {
            throw new DeserializationException();
        }
        NullRegion region = new NullRegion();
        try {
            switch (selectionType.ordinal()) {
                case 1: {
                    region = new CuboidRegion(worldEditWorld, VectorParser.asBlockVector3(selectionSection.getString("min")), VectorParser.asBlockVector3(selectionSection.getString("max")));
                    break;
                }
                case 2: {
                    region = new CylinderRegion(worldEditWorld, VectorParser.asBlockVector3(selectionSection.getString("center")), VectorParser.asVector2(selectionSection.getString("radius")), selectionSection.getInt("minY"), selectionSection.getInt("maxY"));
                    break;
                }
                case 3: 
                case 4: {
                    region = new EllipsoidRegion(worldEditWorld, VectorParser.asBlockVector3(selectionSection.getString("center")), VectorParser.asVector3(selectionSection.getString("radius")));
                    break;
                }
                case 5: {
                    List<BlockVector2> points = selectionSection.getStringList("points").stream().map(VectorParser::asBlockVector2).toList();
                    region = new Polygonal2DRegion(worldEditWorld, points, selectionSection.getInt("minY"), selectionSection.getInt("maxY"));
                    break;
                }
                case 6: {
                    List<BlockVector3> vertices = selectionSection.getStringList("vertices").stream().map(VectorParser::asBlockVector3).toList();
                    ConvexPolyhedralRegion convexRegion = new ConvexPolyhedralRegion(worldEditWorld);
                    for (BlockVector3 blockVector3 : vertices) {
                        convexRegion.addVertex(blockVector3);
                    }
                    region = convexRegion;
                }
            }
        }
        catch (IllegalArgumentException exception) {
            throw new DeserializationException("Could not deserialize region " + String.valueOf(region), exception);
        }
        SelectionRegion selectionRegion = new SelectionRegion(name, selectionType, (Region)region);
        selectionRegion.setChance(chance);
        ConfigurationSection compositionsSection = section.getConfigurationSection("compositions");
        if (compositionsSection != null) {
            SelectionRegion.deserializeCompositions(compositionsSection).forEach(composition -> selectionRegion.getCompositionManager().add((CataMineComposition)composition));
        }
        return selectionRegion;
    }

    @Override
    public String toString() {
        return "SelectionRegion{selectionType=" + String.valueOf((Object)this.selectionType) + ", region=" + String.valueOf(this.region) + "} " + super.toString();
    }

    public static enum SelectionType {
        NONE("none"),
        CUBOID("cuboid"),
        CYLINDER("Cylinder"),
        ELLIPSOID("ellipsoid"),
        SPHERE("sphere"),
        POLYGONAL2D("2Dx1D polygon"),
        CONVEXPOLYHEDRAL("Convex Polyhedron");

        private final String typeName;

        private SelectionType(String typeName) {
            this.typeName = typeName;
        }

        public static SelectionType getType(String typeName) {
            for (SelectionType type : SelectionType.values()) {
                if (!type.typeName.equalsIgnoreCase(typeName)) continue;
                return type;
            }
            return NONE;
        }
    }
}

