/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.mine.components.region.impl;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import me.catalysmrl.catamines.api.serialization.DeserializationException;
import me.catalysmrl.catamines.mine.components.region.AbstractCataMineRegion;
import me.catalysmrl.catamines.mine.components.region.CataMineRegion;
import me.catalysmrl.catamines.utils.worldedit.VectorParser;
import me.catalysmrl.catamines.utils.worldedit.WorldEditUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public class SchematicRegion
extends AbstractCataMineRegion {
    private String schematicName;
    private World world;
    private BlockVector3 location;
    private Clipboard clipboard;

    public SchematicRegion(String name, String schematicName, World world, BlockVector3 location) {
        super(name);
        this.schematicName = schematicName;
        this.world = world;
        this.location = location;
        this.clipboard = WorldEditUtils.loadSchematic(schematicName);
    }

    public void redefine(String schematicName, World world, BlockVector3 location) {
        this.schematicName = schematicName;
        this.world = world;
        this.location = location;
        this.clipboard = WorldEditUtils.loadSchematic(schematicName);
    }

    @Override
    public void fill() {
        WorldEditUtils.pasteSchematic(this.clipboard, this.world, this.location);
    }

    @Override
    public CataMineRegion.RegionType getType() {
        return CataMineRegion.RegionType.SCHEMATIC;
    }

    @Override
    public long getVolume() {
        return this.clipboard.getVolume();
    }

    @Override
    public void serialize(ConfigurationSection section) {
        super.serialize(section);
        section.set("schematic-name", (Object)this.schematicName);
        section.set("world", (Object)this.world.getName());
        section.set("location", (Object)this.location.toParserString());
        this.serializeCompositions(section.createSection("compositions"));
    }

    public static SchematicRegion deserialize(ConfigurationSection section) throws DeserializationException {
        BlockVector3 location;
        String name = section.getString("name");
        if (name == null) {
            throw new DeserializationException("No name specified");
        }
        String schematicName = section.getString("schematic-name");
        if (schematicName == null) {
            throw new DeserializationException("No schematic specified");
        }
        String worldName = section.getString("world");
        if (worldName == null) {
            throw new DeserializationException("No world specified");
        }
        org.bukkit.World bukkitWorld = Bukkit.getWorld((String)worldName);
        if (bukkitWorld == null) {
            throw new DeserializationException("World " + worldName + " not found");
        }
        World worldEditWorld = BukkitAdapter.adapt((org.bukkit.World)bukkitWorld);
        try {
            location = VectorParser.asBlockVector3(section.getString("location"));
        }
        catch (IllegalArgumentException exception) {
            throw new DeserializationException("Invalid location", exception);
        }
        return new SchematicRegion(name, schematicName, worldEditWorld, location);
    }

    @Override
    public String toString() {
        return "SchematicRegion{schemName='" + this.schematicName + "', location=" + String.valueOf(this.location) + ", clipboard=" + String.valueOf(this.clipboard) + "} " + super.toString();
    }
}

