/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.mine.components.region;

import java.util.ArrayList;
import java.util.List;
import me.catalysmrl.catamines.api.serialization.DeserializationException;
import me.catalysmrl.catamines.mine.components.composition.CataMineComposition;
import me.catalysmrl.catamines.mine.components.manager.choice.ChoiceManager;
import me.catalysmrl.catamines.mine.components.region.CataMineRegion;
import org.bukkit.configuration.ConfigurationSection;

public abstract class AbstractCataMineRegion
implements CataMineRegion {
    protected String name;
    protected double chance;
    protected ChoiceManager<CataMineComposition> compositionManager;

    public AbstractCataMineRegion(String name) {
        this.name = name;
        this.compositionManager = new ChoiceManager();
    }

    @Override
    public void serialize(ConfigurationSection section) {
        section.set("region-type", (Object)this.getType().toString());
        section.set("name", (Object)this.name);
        section.set("chance", (Object)this.chance);
    }

    public void serializeCompositions(ConfigurationSection compositionsSection) {
        for (int i = 0; i < this.compositionManager.getChoices().size(); ++i) {
            this.compositionManager.getChoices().get(i).serialize(compositionsSection.createSection("composition-" + i));
        }
    }

    public static List<CataMineComposition> deserializeCompositions(ConfigurationSection compositionsSection) throws DeserializationException {
        ArrayList<CataMineComposition> compositionList = new ArrayList<CataMineComposition>();
        for (String key : compositionsSection.getKeys(false)) {
            ConfigurationSection compositionSection = compositionsSection.getConfigurationSection(key);
            if (compositionSection == null) continue;
            compositionList.add(CataMineComposition.deserialize(compositionSection));
        }
        return compositionList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    public void setChance(double chance) {
        this.chance = chance;
    }

    @Override
    public ChoiceManager<CataMineComposition> getCompositionManager() {
        return this.compositionManager;
    }

    public String toString() {
        return "AbstractCataMineRegion{name='" + this.name + "', chance=" + this.chance + ", compositionManager=" + String.valueOf(this.compositionManager) + "}";
    }
}

