/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.mine.components.manager.controller;

import me.catalysmrl.catamines.api.mine.CataMine;
import me.catalysmrl.catamines.api.serialization.SectionSerializable;
import org.bukkit.configuration.ConfigurationSection;

public class CataMineController
implements SectionSerializable {
    private final CataMine mine;
    private ResetMode resetMode = ResetMode.TIME;
    private int resetDelay;
    private double resetPercentage;
    private int countdown;
    private long blockCount;

    public CataMineController(CataMine mine) {
        this.mine = mine;
    }

    public void tick() {
        switch (this.resetMode.ordinal()) {
            case 0: {
                this.tickTime();
                break;
            }
            case 1: {
                this.tickPercentage();
                break;
            }
            case 2: {
                if (this.tickTime()) break;
                this.tickPercentage();
            }
        }
    }

    public boolean tickTime() {
        if (this.resetDelay < 0) {
            return true;
        }
        if (this.countdown <= 0) {
            this.countdown = this.resetDelay;
            this.mine.reset(this.mine.getPlugin());
            return true;
        }
        --this.countdown;
        return false;
    }

    public boolean tickPercentage() {
        return false;
    }

    @Override
    public void serialize(ConfigurationSection section) {
        section.set("reset-mode", (Object)this.resetMode.toString());
        section.set("reset-delay", (Object)this.resetDelay);
        section.set("reset-percentage", (Object)this.resetPercentage);
        section.set("countdown", (Object)this.countdown);
    }

    public static CataMineController deserialize(ConfigurationSection section, CataMine mine) {
        ResetMode mode = ResetMode.valueOf(section.getString("reset-mode"));
        int resetDelay = section.getInt("reset-delay", 0);
        double resetPercentage = section.getDouble("reset-percentage", 0.0);
        int countdown = section.getInt("countdown", 0);
        CataMineController controller = new CataMineController(mine);
        controller.setResetMode(mode);
        controller.setResetDelay(resetDelay);
        controller.setResetPercentage(resetPercentage);
        controller.setCountdown(countdown);
        return controller;
    }

    public ResetMode getResetMode() {
        return this.resetMode;
    }

    public void setResetMode(ResetMode resetMode) {
        this.resetMode = resetMode;
    }

    public int getResetDelay() {
        return this.resetDelay;
    }

    public void setResetDelay(int resetDelay) {
        this.resetDelay = resetDelay;
    }

    public double getResetPercentage() {
        return this.resetPercentage;
    }

    public void setResetPercentage(double resetPercentage) {
        this.resetPercentage = resetPercentage;
    }

    public int getCountdown() {
        return this.countdown;
    }

    public void setCountdown(int countdown) {
        this.countdown = countdown;
    }

    public long getBlockCount() {
        return this.blockCount;
    }

    public void setBlockCount(long blockCount) {
        this.blockCount = blockCount;
    }

    public static enum ResetMode {
        TIME,
        PERCENTAGE,
        TIME_PERCENTAGE;

    }
}

