/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.mine.components.manager.choice;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import me.catalysmrl.catamines.mine.components.manager.choice.Choice;
import me.catalysmrl.catamines.mine.components.manager.choice.Identifiable;

public class ChoiceManager<T extends Identifiable & Choice> {
    private T current;
    private T upcoming;
    private final List<T> choices = new ArrayList<T>();
    private double max = 0.0;

    public ChoiceManager() {
    }

    public ChoiceManager(List<T> choices) {
        this.choices.addAll(choices);
        this.next();
    }

    public void next() {
        this.current = this.upcoming;
        double randomDouble = ThreadLocalRandom.current().nextDouble();
        double offset = 0.0;
        for (Identifiable choice : this.choices) {
            if (randomDouble <= (offset + ((Choice)((Object)choice)).getChance()) / this.max) {
                this.upcoming = choice;
                return;
            }
            offset += ((Choice)((Object)choice)).getChance();
        }
    }

    public void add(T choice) {
        this.choices.add(choice);
        this.max += ((Choice)choice).getChance();
        if (this.upcoming == null) {
            this.upcoming = choice;
        }
    }

    public void remove(T choice) {
        this.choices.remove(choice);
    }

    public Optional<T> get(String name) {
        return this.getChoices().stream().filter(choice -> choice.getName().equals(name)).findFirst();
    }

    public Optional<T> getCurrent() {
        return Optional.ofNullable(this.current);
    }

    public void setCurrent(T current) {
        this.current = current;
    }

    public Optional<T> getUpcoming() {
        return Optional.ofNullable(this.upcoming);
    }

    public void setUpcoming(T upcoming) {
        this.upcoming = upcoming;
    }

    public List<T> getChoices() {
        return this.choices;
    }

    public String toString() {
        return "ChoiceManager{current=" + String.valueOf(this.current) + ", upcoming=" + String.valueOf(this.upcoming) + ", choices=" + String.valueOf(this.choices) + "}";
    }
}

