/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.mine.components.composition;

import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.pattern.RandomPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.catalysmrl.catamines.api.serialization.DeserializationException;
import me.catalysmrl.catamines.api.serialization.SectionSerializable;
import me.catalysmrl.catamines.mine.components.composition.CataMineBlock;
import me.catalysmrl.catamines.mine.components.manager.choice.Choice;
import me.catalysmrl.catamines.mine.components.manager.choice.Identifiable;
import me.catalysmrl.catamines.mine.reward.Rewardable;
import org.bukkit.configuration.ConfigurationSection;

public class CataMineComposition
implements Rewardable,
Identifiable,
Choice,
SectionSerializable {
    private String name;
    private double chance;
    private List<CataMineBlock> blocks = new ArrayList<CataMineBlock>();
    private RandomPattern randomPattern;

    public CataMineComposition(String name) {
        this.name = name;
    }

    public void add(CataMineBlock block) {
        Objects.requireNonNull(block);
        this.blocks.removeIf(cataMineBlock -> block.getBaseBlock().equals((Object)cataMineBlock.getBaseBlock()));
        this.blocks.add(block);
        this.updateRandomPattern();
    }

    public void remove(CataMineBlock block) throws IllegalArgumentException {
        if (!this.blocks.remove(block)) {
            throw new IllegalArgumentException("Block is not in composition");
        }
    }

    private void updateRandomPattern() {
        this.randomPattern = new RandomPattern();
        this.blocks.stream().filter(b -> b.getChance() > 0.0).forEach(b -> this.randomPattern.add((Pattern)b.getBaseBlock(), b.getChance()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    public void setChance(double chance) {
        this.chance = chance;
    }

    public double getChanceSum() {
        return this.blocks.stream().mapToDouble(CataMineBlock::getChance).sum();
    }

    public List<CataMineBlock> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<CataMineBlock> blocks) {
        this.blocks = blocks;
        this.updateRandomPattern();
    }

    public RandomPattern getRandomPattern() {
        return this.randomPattern;
    }

    @Override
    public void serialize(ConfigurationSection section) {
        section.set("name", (Object)this.name);
        section.set("chance", (Object)this.chance);
        ConfigurationSection blocksSection = section.createSection("blocks");
        for (int i = 0; i < this.blocks.size(); ++i) {
            this.blocks.get(i).serialize(blocksSection.createSection("block-" + i));
        }
    }

    public static CataMineComposition deserialize(ConfigurationSection section) throws DeserializationException {
        String name = section.getString("name");
        if (name == null) {
            throw new DeserializationException("Name not specified");
        }
        double chance = section.getDouble("chance", 0.0);
        ConfigurationSection blocksSection = section.getConfigurationSection("blocks");
        ArrayList<CataMineBlock> blockList = new ArrayList<CataMineBlock>();
        if (blocksSection != null) {
            for (String key : blocksSection.getKeys(false)) {
                ConfigurationSection blockSection = blocksSection.getConfigurationSection(key);
                if (blockSection == null) continue;
                CataMineBlock block = CataMineBlock.deserialize(blockSection);
                blockList.add(block);
            }
        }
        CataMineComposition composition = new CataMineComposition(name);
        composition.setChance(chance);
        composition.setBlocks(blockList);
        return composition;
    }

    public String toString() {
        return "CataMineComposition{name='" + this.name + "', chance=" + this.chance + ", blocks=" + String.valueOf(this.blocks) + ", randomPattern=" + String.valueOf(this.randomPattern) + "}";
    }
}

