/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.mine.components.composition;

import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.ArrayList;
import java.util.List;
import me.catalysmrl.catamines.api.serialization.DeserializationException;
import me.catalysmrl.catamines.api.serialization.SectionSerializable;
import me.catalysmrl.catamines.mine.components.composition.drop.CataMineItem;
import me.catalysmrl.catamines.mine.components.manager.choice.Choice;
import me.catalysmrl.catamines.utils.message.Message;
import me.catalysmrl.catamines.utils.worldedit.BaseBlockParser;
import org.bukkit.configuration.ConfigurationSection;

public class CataMineBlock
implements Choice,
SectionSerializable {
    private BaseBlock baseBlock;
    private double chance;
    private DropType dropType;
    private List<CataMineItem> items;

    public CataMineBlock(BaseBlock baseBlock, double chance) {
        this(baseBlock, chance, DropType.CUSTOM);
    }

    public CataMineBlock(BaseBlock baseBlock, double chance, DropType dropType) {
        this(baseBlock, chance, dropType, new ArrayList<CataMineItem>());
    }

    public CataMineBlock(BaseBlock baseBlock, double chance, DropType dropType, List<CataMineItem> items) {
        if (chance < 0.0 || chance > 100.0) {
            throw new IllegalArgumentException(Message.SET_INVALID_CHANCE.getMessage());
        }
        this.baseBlock = baseBlock;
        this.chance = (double)Math.round(chance * 100.0) / 100.0;
        this.dropType = dropType;
        this.items = items;
    }

    @Override
    public void serialize(ConfigurationSection section) {
        section.set("block", (Object)this.baseBlock.toString());
        section.set("chance", (Object)this.chance);
        section.set("drop-type", (Object)this.dropType.toString());
        ConfigurationSection lootTableSection = section.createSection("loot-table");
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).serialize(lootTableSection.createSection("item-" + i));
        }
    }

    public static CataMineBlock deserialize(ConfigurationSection section) throws DeserializationException {
        BaseBlock baseBlock;
        String blockString = section.getString("block");
        if (blockString == null) {
            throw new DeserializationException("Missing 'block' path");
        }
        try {
            baseBlock = BaseBlockParser.parseInput(blockString);
        }
        catch (InputParseException exception) {
            throw new DeserializationException("Could not deserialize " + blockString, exception);
        }
        double chance = section.getDouble("chance", 0.0);
        DropType dropType = DropType.valueOf(section.getString("drop-type", "CUSTOM"));
        ConfigurationSection itemsSection = section.getConfigurationSection("loot-table");
        ArrayList<CataMineItem> itemList = new ArrayList<CataMineItem>();
        if (itemsSection != null) {
            for (String key : itemsSection.getKeys(false)) {
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
                if (itemSection == null) continue;
                itemList.add(CataMineItem.deserialize(itemSection));
            }
        }
        return new CataMineBlock(baseBlock, chance, dropType, itemList);
    }

    public BaseBlock getBaseBlock() {
        return this.baseBlock;
    }

    public void setBaseBlock(BaseBlock baseBlock) {
        this.baseBlock = baseBlock;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    public void setChance(double chance) {
        if (chance < 0.0 || chance > 100.0) {
            throw new IllegalArgumentException("Invalid chance");
        }
        this.chance = (double)Math.round(chance * 100.0) / 100.0;
    }

    public DropType getDropType() {
        return this.dropType;
    }

    public void setDropType(DropType dropType) {
        this.dropType = dropType;
    }

    public List<CataMineItem> getItems() {
        return this.items;
    }

    public void setItems(List<CataMineItem> items) {
        this.items = items;
    }

    public String toString() {
        return "CataMineBlock{baseBlock=" + String.valueOf(this.baseBlock) + ", chance=" + this.chance + ", dropType=" + String.valueOf((Object)this.dropType) + ", drops=" + String.valueOf(this.items) + "}";
    }

    public static enum DropType {
        CUSTOM,
        ALL,
        SINGLE;

    }
}

