/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.managers.blockmanagers;

import java.util.ArrayDeque;
import java.util.Deque;
import me.catalysmrl.catamines.mine.components.region.CataMineRegion;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BlockApplicator {
    private static final long MAX_BLOCK_UPDATES_PER_TICK = 5000000L;
    protected JavaPlugin plugin;
    protected Deque<CataMineRegion> resetQueue = new ArrayDeque<CataMineRegion>();

    public BlockApplicator(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public abstract void start();

    public abstract void cancel();

    public void queueForReset(CataMineRegion region) {
        this.resetQueue.offer(region);
    }

    protected void handleQueue() {
        long blockUpdates = 0L;
        while (!this.resetQueue.isEmpty()) {
            CataMineRegion region = this.resetQueue.pop();
            region.fill();
            if ((blockUpdates += region.getVolume()) <= 5000000L) continue;
            break;
        }
    }
}

