/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.managers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.catalysmrl.catamines.CataMines;
import me.catalysmrl.catamines.api.mine.CataMine;
import me.catalysmrl.catamines.api.serialization.DeserializationException;
import me.catalysmrl.catamines.managers.blockmanagers.BlockApplicator;
import me.catalysmrl.catamines.managers.blockmanagers.BukkitBlockApplicationManager;
import me.catalysmrl.catamines.managers.blockmanagers.FastAsyncBlockApplicationManager;
import me.catalysmrl.catamines.mine.components.region.CataMineRegion;
import me.catalysmrl.catamines.mine.mines.AdvancedCataMine;
import me.catalysmrl.catamines.utils.helper.CompatibilityProvider;
import me.catalysmrl.catamines.utils.message.Message;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class MineManager {
    private final Path minesPath;
    private final CataMines plugin;
    private BukkitTask minesTask;
    private BlockApplicator blockApplicator;
    private final List<CataMine> mines = new ArrayList<CataMine>();

    public MineManager(CataMines plugin) {
        this.plugin = plugin;
        this.minesPath = plugin.getDataFolder().toPath().resolve("mines");
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> this.loadMinesFromFolder(this.minesPath), 2L);
        this.start();
    }

    public void start() {
        this.initBlockApplicator();
        this.initMineTask();
    }

    public void shutDown() {
        this.blockApplicator.cancel();
        this.minesTask.cancel();
        for (CataMine mine : this.mines) {
            try {
                this.saveMine(mine);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe(Message.MINE_SAVE_EXCEPTION.getMessage(mine.getName()));
            }
        }
    }

    private void initBlockApplicator() {
        Logger logger = this.plugin.getLogger();
        logger.info("Starting BlockApplicationManager...");
        if (this.blockApplicator != null) {
            logger.warning("BlockApplicationManager already running. Cancelling manager");
            this.blockApplicator.cancel();
        }
        if (CompatibilityProvider.isFaweEnabled()) {
            logger.info("Initializing FastAsyncBlockApplicationManager");
            this.blockApplicator = new FastAsyncBlockApplicationManager(this.plugin);
        } else {
            logger.info("Initializing BukkitBlockApplicationManager");
            this.blockApplicator = new BukkitBlockApplicationManager(this.plugin);
        }
        this.blockApplicator.start();
    }

    private void initMineTask() {
        Logger logger = this.plugin.getLogger();
        logger.info("Starting mine task...");
        if (this.minesTask != null) {
            logger.warning("Mine task already running. Overriding old mine task.");
            this.minesTask.cancel();
        }
        this.minesTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (CataMine cataMine : this.mines) {
                cataMine.tick();
            }
        }, 0L, 20L);
    }

    public void resetRegion(CataMineRegion region) {
        this.blockApplicator.queueForReset(region);
    }

    public List<CataMine> getMinesFromFolder(Path folder) {
        Objects.requireNonNull(folder);
        List<CataMine> cataMines = new ArrayList<CataMine>();
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            this.plugin.getLogger().severe("Path is not a directory: " + String.valueOf(folder));
            return cataMines;
        }
        try (Stream<Path> stream = Files.list(folder);){
            cataMines = stream.map(this::deserializeCataMineFromYaml).flatMap(Optional::stream).collect(Collectors.toList());
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed loading directory: " + String.valueOf(folder));
        }
        this.plugin.getLogger().info("Loaded " + cataMines.size() + " mines");
        return cataMines;
    }

    private Optional<CataMine> deserializeCataMineFromYaml(Path path) {
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)path.toFile());
        return this.deserializeCataMine((ConfigurationSection)cfg);
    }

    private Optional<CataMine> deserializeCataMine(ConfigurationSection section) {
        AdvancedCataMine mine = null;
        try {
            mine = AdvancedCataMine.deserialize(this.plugin, section);
        }
        catch (DeserializationException e) {
            e.printStackTrace();
        }
        return Optional.ofNullable(mine);
    }

    public void loadMinesFromFolder(Path folder) {
        this.mines.clear();
        this.mines.addAll(this.getMinesFromFolder(folder));
    }

    public void callBlockBreak(BlockBreakEvent event) {
    }

    public void callBlockPlace(BlockPlaceEvent event) {
    }

    public Optional<CataMine> getMine(String id) {
        return this.mines.stream().filter(cataMine -> cataMine.getName().equals(id)).findFirst();
    }

    public List<CataMine> getMines() {
        return this.mines;
    }

    public List<String> getMineList() {
        return this.mines.stream().map(CataMine::getName).collect(Collectors.toList());
    }

    public boolean containsMine(String id) {
        return this.mines.stream().anyMatch(mine -> mine.getName().equals(id));
    }

    public boolean containsMine(CataMine mine) {
        return this.containsMine(mine.getName());
    }

    public void registerMine(CataMine mine) {
        if (this.containsMine(mine)) {
            throw new IllegalArgumentException();
        }
        this.mines.add(mine);
    }

    public void deleteMine(CataMine cataMine) throws IOException {
        this.mines.remove(cataMine);
        Files.deleteIfExists(this.plugin.getDataFolder().toPath().resolve("mines").resolve(cataMine.getName() + ".yml"));
    }

    public void saveMine(CataMine mine) throws IOException {
        Path file = this.plugin.getDataFolder().toPath().resolve("mines").resolve(mine.getName() + ".yml");
        YamlConfiguration fileCfg = new YamlConfiguration();
        mine.serialize((ConfigurationSection)fileCfg);
        fileCfg.save(file.toFile());
    }

    public Path getMinesPath() {
        return this.minesPath;
    }
}

