/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.command.abstraction.mine.region;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import me.catalysmrl.catamines.CataMines;
import me.catalysmrl.catamines.api.mine.CataMine;
import me.catalysmrl.catamines.command.abstraction.mine.AbstractMineCommand;
import me.catalysmrl.catamines.mine.components.region.CataMineRegion;
import me.catalysmrl.catamines.utils.message.Message;
import me.catalysmrl.catamines.utils.message.Messages;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public abstract class AbstractRegionCommand
extends AbstractMineCommand {
    public AbstractRegionCommand(String name, String permission, Predicate<Integer> argumentCheck, boolean onlyPlayers) {
        super(name, permission, argumentCheck, onlyPlayers);
    }

    @Override
    public void execute(CataMines plugin, CommandSender sender, List<String> args, CataMine mine) {
        String regionName = args.get(0);
        Optional<CataMineRegion> regionOptional = mine.getRegionManager().get(regionName);
        if (regionOptional.isEmpty()) {
            Message.REGION_NOT_EXISTS.send(sender, regionName);
            return;
        }
        this.execute(plugin, sender, args.subList(1, args.size()), mine, regionOptional.get());
    }

    @Override
    public List<String> tabComplete(CataMines plugin, CommandSender sender, List<String> args, CataMine mine) {
        if (args.size() == 1) {
            return (List)StringUtil.copyPartialMatches((String)args.get(0), mine.getRegionManager().getChoices().stream().map(CataMineRegion::getName).toList(), new ArrayList());
        }
        Optional<CataMineRegion> regionOptional = mine.getRegionManager().get(args.get(0));
        if (regionOptional.isEmpty()) {
            return List.of(Messages.colorize("&cUnknown region"));
        }
        return this.tabComplete(plugin, sender, args.subList(1, args.size()), mine, regionOptional.get());
    }

    public abstract void execute(CataMines var1, CommandSender var2, List<String> var3, CataMine var4, CataMineRegion var5);

    public List<String> tabComplete(CataMines plugin, CommandSender sender, List<String> args, CataMine mine, CataMineRegion region) {
        return Collections.emptyList();
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getUsage() {
        return "";
    }
}

