/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.command.abstraction.mine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import me.catalysmrl.catamines.CataMines;
import me.catalysmrl.catamines.api.mine.CataMine;
import me.catalysmrl.catamines.command.abstraction.AbstractCommand;
import me.catalysmrl.catamines.command.abstraction.CommandException;
import me.catalysmrl.catamines.command.utils.ArgumentException;
import me.catalysmrl.catamines.utils.message.Message;
import me.catalysmrl.catamines.utils.message.Messages;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public abstract class AbstractMineCommand
extends AbstractCommand {
    public AbstractMineCommand(String name, String permission, Predicate<Integer> argumentCheck, boolean onlyPlayers) {
        super(name, permission, argumentCheck, onlyPlayers);
    }

    @Override
    public final void execute(CataMines plugin, CommandSender sender, List<String> args) throws CommandException {
        if (args.isEmpty()) {
            throw new ArgumentException.Usage();
        }
        String mineID = args.get(0);
        if ("*".equals(mineID)) {
            if (!sender.hasPermission("catamines.admin")) {
                Message.NO_PERMISSION.send(sender);
                return;
            }
            ArrayList<CataMine> mines = new ArrayList<CataMine>(plugin.getMineManager().getMines());
            List<String> strippedArgs = args.subList(1, args.size());
            for (CataMine mine : mines) {
                this.execute(plugin, sender, strippedArgs, mine);
            }
            sender.sendMessage("");
            Message.QUERY_ALL.send(sender, mines.size());
            sender.sendMessage("");
            return;
        }
        Optional<CataMine> mineOptional = plugin.getMineManager().getMine(mineID);
        if (mineOptional.isEmpty()) {
            Message.MINE_NOT_EXISTS.send(sender, mineID);
            return;
        }
        this.execute(plugin, sender, args.subList(1, args.size()), mineOptional.get());
    }

    public abstract void execute(CataMines var1, CommandSender var2, List<String> var3, CataMine var4);

    @Override
    public List<String> tabComplete(CataMines plugin, CommandSender sender, List<String> args) {
        if (args.size() == 1) {
            return (List)StringUtil.copyPartialMatches((String)args.get(0), plugin.getMineManager().getMineList(), new ArrayList());
        }
        Optional<CataMine> optionalCataMine = plugin.getMineManager().getMine(args.get(0));
        if (optionalCataMine.isEmpty()) {
            return List.of(Messages.colorize("&cUnknown mine"));
        }
        CataMine mine = optionalCataMine.get();
        return this.tabComplete(plugin, sender, args.subList(1, args.size()), mine);
    }

    public List<String> tabComplete(CataMines plugin, CommandSender sender, List<String> args, CataMine mine) {
        return Collections.emptyList();
    }
}

