/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.command.abstraction;

import java.util.Optional;
import java.util.function.Predicate;
import me.catalysmrl.catamines.command.abstraction.Command;
import org.bukkit.command.CommandSender;

public abstract class AbstractCommand
implements Command {
    private final String name;
    private final String permission;
    private final Predicate<Integer> argumentCheck;
    private final boolean onlyPlayers;

    public AbstractCommand(String name, String permission, Predicate<Integer> argumentCheck, boolean onlyPlayers) {
        this.name = name;
        this.permission = permission;
        this.argumentCheck = argumentCheck;
        this.onlyPlayers = onlyPlayers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getPermission() {
        return Optional.ofNullable(this.permission);
    }

    @Override
    public Predicate<Integer> checkArgLength() {
        return this.argumentCheck;
    }

    @Override
    public boolean onlyPlayers() {
        return this.onlyPlayers;
    }

    @Override
    public boolean isAuthorized(CommandSender sender) {
        return this.permission == null || sender.hasPermission(this.permission);
    }
}

