/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines.command;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.catalysmrl.catamines.CataMines;
import me.catalysmrl.catamines.command.abstraction.Command;
import me.catalysmrl.catamines.command.abstraction.CommandException;
import me.catalysmrl.catamines.commands.generic.HelpCommand;
import me.catalysmrl.catamines.commands.generic.ListCommand;
import me.catalysmrl.catamines.commands.generic.ReloadCommand;
import me.catalysmrl.catamines.commands.mine.generic.CreateCommand;
import me.catalysmrl.catamines.commands.mine.generic.DebugCommand;
import me.catalysmrl.catamines.commands.mine.generic.DeleteCommand;
import me.catalysmrl.catamines.commands.mine.generic.DisplayNameCommand;
import me.catalysmrl.catamines.commands.mine.generic.InfoCommand;
import me.catalysmrl.catamines.commands.mine.generic.RenameCommand;
import me.catalysmrl.catamines.commands.mine.generic.ResetCommand;
import me.catalysmrl.catamines.commands.mine.generic.SetCommand;
import me.catalysmrl.catamines.commands.mine.generic.TimerCommand;
import me.catalysmrl.catamines.commands.mine.regions.RegionsCommand;
import me.catalysmrl.catamines.utils.message.Message;
import me.catalysmrl.catamines.utils.message.Messages;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager
implements TabExecutor {
    private final CataMines plugin;
    private final Map<String, Command> commandMap;

    public CommandManager(CataMines plugin) {
        this.plugin = plugin;
        this.commandMap = ImmutableMap.builder().put((Object)"help", (Object)new HelpCommand()).put((Object)"list", (Object)new ListCommand()).put((Object)"reload", (Object)new ReloadCommand()).put((Object)"info", (Object)new InfoCommand()).put((Object)"debug", (Object)new DebugCommand()).put((Object)"create", (Object)new CreateCommand()).put((Object)"delete", (Object)new DeleteCommand()).put((Object)"reset", (Object)new ResetCommand()).put((Object)"set", (Object)new SetCommand()).put((Object)"rename", (Object)new RenameCommand()).put((Object)"displayname", (Object)new DisplayNameCommand()).put((Object)"timer", (Object)new TimerCommand()).put((Object)"regions", (Object)new RegionsCommand()).build();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command command, @NotNull String label, @NotNull String[] args) {
        String subCmd = args.length == 0 ? "help" : args[0].toLowerCase(Locale.ROOT);
        Command cataCommand = this.getCommand(subCmd);
        if (cataCommand == null) {
            Message.UNKNOWN_COMMAND.send(sender);
            return true;
        }
        if (cataCommand.onlyPlayers() && !(sender instanceof Player)) {
            Message.ONLY_PLAYERS.send(sender);
            return true;
        }
        if (!cataCommand.isAuthorized(sender)) {
            Message.NO_PERMISSION.send(sender);
            return true;
        }
        ArrayList<String> strippedArgs = new ArrayList<String>(Arrays.asList(args));
        if (!strippedArgs.isEmpty()) {
            strippedArgs.remove(0);
        }
        if (!cataCommand.checkArgLength().test(strippedArgs.size())) {
            Messages.send(sender, cataCommand.getUsage());
            return true;
        }
        try {
            cataCommand.execute(this.plugin, sender, strippedArgs);
        }
        catch (CommandException e) {
            e.handle(sender, cataCommand);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull org.bukkit.command.Command command, @NotNull String label, @NotNull String[] args) {
        List<Command> commands = this.commandMap.values().stream().filter(c -> c.isAuthorized(commandSender)).toList();
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], (Iterable)commands.stream().map(Command::getName).collect(Collectors.toList()), new ArrayList());
        }
        if (args.length > 1) {
            return commands.stream().filter(c -> c.getName().equalsIgnoreCase(args[0]) || c.getAliases().contains(args[0].toLowerCase(Locale.ROOT))).findFirst().map(c -> c.tabComplete(this.plugin, commandSender, Arrays.asList(Arrays.copyOfRange(args, 1, args.length)))).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public Command getCommand(String commandName) {
        if (this.commandMap.containsKey(commandName)) {
            return this.commandMap.get(commandName);
        }
        return this.commandMap.values().stream().filter(command -> command.getName().equals(commandName)).findFirst().orElse(null);
    }

    public Map<String, Command> getCommandMap() {
        return this.commandMap;
    }
}

