/*
 * Decompiled with CFR 0.152.
 */
package me.catalysmrl.catamines;

import me.catalysmrl.catamines.command.CommandManager;
import me.catalysmrl.catamines.listeners.BlockListeners;
import me.catalysmrl.catamines.managers.MineManager;
import me.catalysmrl.catamines.mine.placeholders.CataMinePlaceHolders;
import me.catalysmrl.catamines.utils.helper.CompatibilityProvider;
import me.catalysmrl.catamines.utils.message.LangSystem;
import me.catalysmrl.catamines.utils.metrics.bukkit.Metrics;
import me.catalysmrl.catamines.utils.metrics.charts.SimplePie;
import me.catalysmrl.catamines.utils.metrics.charts.SingleLineChart;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class CataMines
extends JavaPlugin {
    private static CataMines INSTANCE;
    private MineManager mineManager;
    private CommandManager commandManager;

    public static CataMines getInstance() {
        return INSTANCE;
    }

    public void onLoad() {
        INSTANCE = this;
        this.saveDefaultConfig();
    }

    public void onEnable() {
        CompatibilityProvider.checkCompatibility();
        new LangSystem(this);
        this.mineManager = new MineManager(this);
        this.registerCommands();
        this.registerListeners();
        if (CompatibilityProvider.isPapiEnabled()) {
            new CataMinePlaceHolders(this).register();
        }
        this.setupMetrics();
    }

    public void onDisable() {
        INSTANCE = null;
        this.commandManager = null;
        this.mineManager.shutDown();
        this.mineManager = null;
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics(this, 12889);
        metrics.addCustomChart(new SimplePie("we_implementation", () -> CompatibilityProvider.isFaweEnabled() ? "FastAsyncWorldEdit" : "WorldEdit"));
        metrics.addCustomChart(new SingleLineChart("mines", () -> this.mineManager.getMines().size()));
    }

    private void registerCommands() {
        this.commandManager = new CommandManager(this);
        PluginCommand command = this.getCommand("catamines");
        if (command == null) {
            this.getLogger().severe("***************************************");
            this.getLogger().severe("Could not register commands. All plugin");
            this.getLogger().severe("functions may still work apart from commands");
            this.getLogger().severe("***************************************");
            return;
        }
        command.setExecutor((CommandExecutor)this.commandManager);
    }

    private void registerListeners() {
        this.getLogger().info("Registering listeners");
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new BlockListeners(this.mineManager), (Plugin)this);
    }

    public MineManager getMineManager() {
        return this.mineManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }
}

