/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_17_0;

import com.github.stefvanschie.inventoryframework.abstraction.EnchantingTableInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_17_0.util.TextHolderUtil;
import java.lang.reflect.Field;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.Containers;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantingTableInventoryImpl
extends EnchantingTableInventory {
    public EnchantingTableInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 2) {
            throw new IllegalArgumentException("The amount of items for an enchanting table should be 2, but is '" + itemAmount + "'");
        }
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        ContainerEnchantingTableImpl containerEnchantmentTable = new ContainerEnchantingTableImpl(serverPlayer, items);
        serverPlayer.bV = containerEnchantmentTable;
        int id = containerEnchantmentTable.j;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        serverPlayer.b.sendPacket((Packet)new PacketPlayOutOpenWindow(id, Containers.m, message));
        this.sendItems(player, items);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        NonNullList nmsItems = NonNullList.a((Object)net.minecraft.world.item.ItemStack.b, (Object[])new net.minecraft.world.item.ItemStack[]{CraftItemStack.asNMSCopy((ItemStack)items[0]), CraftItemStack.asNMSCopy((ItemStack)items[1])});
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        this.getPlayerConnection(serverPlayer).sendPacket((Packet)new PacketPlayOutWindowItems(containerId, nmsItems));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        PacketPlayOutSetSlot packet = new PacketPlayOutSetSlot(-1, -1, net.minecraft.world.item.ItemStack.b);
        this.getPlayerConnection(this.getServerPlayer(player)).sendPacket((Packet)packet);
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.bV.j;
    }

    @NotNull
    @Contract(pure=true)
    private ServerPlayerConnection getPlayerConnection(@NotNull EntityPlayer serverPlayer) {
        return serverPlayer.b;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerEnchantingTableImpl
    extends ContainerEnchantTable {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Field enchantSlotsField;

        public ContainerEnchantingTableImpl(@Nullable EntityPlayer serverPlayer, ItemStack[] items) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.getInventory());
            this.player = serverPlayer.getBukkitEntity();
            try {
                this.enchantSlotsField = ContainerEnchantTable.class.getDeclaredField("n");
                this.enchantSlotsField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            try {
                IInventory input = (IInventory)this.enchantSlotsField.get((Object)this);
                input.setItem(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
                input.setItem(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                try {
                    CraftInventoryEnchanting inventory = new CraftInventoryEnchanting((IInventory)this.enchantSlotsField.get((Object)this)){

                        @NotNull
                        @Contract(pure=true)
                        public InventoryHolder getHolder() {
                            return EnchantingTableInventoryImpl.this.inventoryHolder;
                        }
                    };
                    this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (Container)this);
                }
                catch (IllegalAccessException exception) {
                    exception.printStackTrace();
                }
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean canUse(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void b(EntityHuman nmsPlayer) {
        }
    }
}

