/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.gui;

import com.github.stefvanschie.inventoryframework.gui.type.AnvilGui;
import com.github.stefvanschie.inventoryframework.gui.type.BeaconGui;
import com.github.stefvanschie.inventoryframework.gui.type.CartographyTableGui;
import com.github.stefvanschie.inventoryframework.gui.type.EnchantingTableGui;
import com.github.stefvanschie.inventoryframework.gui.type.GrindstoneGui;
import com.github.stefvanschie.inventoryframework.gui.type.MerchantGui;
import com.github.stefvanschie.inventoryframework.gui.type.ModernSmithingTableGui;
import com.github.stefvanschie.inventoryframework.gui.type.SmithingTableGui;
import com.github.stefvanschie.inventoryframework.gui.type.StonecutterGui;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiListener
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Set<Gui> activeGuiInstances = new HashSet<Gui>();

    public GuiListener(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(@NotNull InventoryClickEvent event) {
        Gui gui = this.getGui(event.getInventory());
        if (gui == null) {
            return;
        }
        InventoryView view = event.getView();
        Inventory inventory = view.getInventory(event.getRawSlot());
        if (inventory == null) {
            gui.callOnOutsideClick(event);
            return;
        }
        gui.callOnGlobalClick(event);
        if (inventory.equals(view.getTopInventory())) {
            gui.callOnTopClick(event);
        } else {
            gui.callOnBottomClick(event);
        }
        gui.click(event);
        if (event.isCancelled()) {
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                PlayerInventory playerInventory = event.getWhoClicked().getInventory();
                playerInventory.setItemInOffHand(playerInventory.getItemInOffHand());
            });
        }
    }

    @Deprecated
    public void resetItemsAnvil(@NotNull InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof AnvilGui) || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        ((AnvilGui)holder).handleClickEvent(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void resetItemsBeacon(@NotNull InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof BeaconGui) || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        ((BeaconGui)holder).handleClickEvent(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void resetItemsCartographyTable(@NotNull InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof CartographyTableGui) || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        ((CartographyTableGui)holder).handleClickEvent(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void resetItemsEnchantingTable(@NotNull InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof EnchantingTableGui) || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        ((EnchantingTableGui)holder).handleClickEvent(event);
    }

    @Deprecated
    public void resetItemsGrindstone(@NotNull InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof GrindstoneGui) || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        ((GrindstoneGui)holder).handleClickEvent(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void resetItemsStonecutter(@NotNull InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof StonecutterGui) || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        ((StonecutterGui)holder).handleClickEvent(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void resetItemsSmithingTable(@NotNull InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof SmithingTableGui) || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        ((SmithingTableGui)holder).handleClickEvent(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityPickupItem(@NotNull EntityPickupItemEvent event) {
        if (!(event.getEntity() instanceof HumanEntity)) {
            return;
        }
        Gui gui = this.getGui(((HumanEntity)event.getEntity()).getOpenInventory().getTopInventory());
        if (gui == null || !gui.isPlayerInventoryUsed()) {
            return;
        }
        int leftOver = gui.getHumanEntityCache().add((HumanEntity)event.getEntity(), event.getItem().getItemStack());
        if (leftOver == 0) {
            event.getItem().remove();
        } else {
            ItemStack itemStack = event.getItem().getItemStack();
            itemStack.setAmount(leftOver);
            event.getItem().setItemStack(itemStack);
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onInventoryDrag(@NotNull InventoryDragEvent event) {
        Gui gui = this.getGui(event.getInventory());
        if (gui == null) {
            return;
        }
        InventoryView view = event.getView();
        Set inventorySlots = event.getRawSlots();
        if (inventorySlots.size() > 1) {
            boolean top = false;
            boolean bottom = false;
            Iterator iterator = inventorySlots.iterator();
            while (iterator.hasNext()) {
                int inventorySlot = (Integer)iterator.next();
                Inventory inventory = view.getInventory(inventorySlot);
                if (view.getTopInventory().equals(inventory)) {
                    top = true;
                } else if (view.getBottomInventory().equals(inventory)) {
                    bottom = true;
                }
                if (!top || !bottom) continue;
                break;
            }
            gui.callOnGlobalDrag(event);
            if (top) {
                gui.callOnTopDrag(event);
            }
            if (bottom) {
                gui.callOnBottomDrag(event);
            }
        } else {
            int index = inventorySlots.toArray(new Integer[0])[0];
            InventoryType.SlotType slotType = view.getSlotType(index);
            boolean even = event.getType() == DragType.EVEN;
            ClickType clickType = even ? ClickType.LEFT : ClickType.RIGHT;
            InventoryAction inventoryAction = even ? InventoryAction.PLACE_SOME : InventoryAction.PLACE_ONE;
            ItemStack previousViewCursor = view.getCursor();
            view.setCursor(event.getOldCursor());
            InventoryClickEvent inventoryClickEvent = new InventoryClickEvent(view, slotType, index, clickType, inventoryAction);
            this.onInventoryClick(inventoryClickEvent);
            if (Objects.equals(view.getCursor(), event.getOldCursor())) {
                view.setCursor(previousViewCursor);
            }
            event.setCancelled(inventoryClickEvent.isCancelled());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTradeSelect(@NotNull TradeSelectEvent event) {
        Gui gui = this.getGui((Inventory)event.getInventory());
        if (!(gui instanceof MerchantGui)) {
            return;
        }
        ((MerchantGui)gui).callOnTradeSelect(event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Gui gui = this.getGui(event.getInventory());
        if (gui == null) {
            return;
        }
        HumanEntity humanEntity = event.getPlayer();
        PlayerInventory playerInventory = humanEntity.getInventory();
        playerInventory.setItemInOffHand(playerInventory.getItemInOffHand());
        if (!gui.isUpdating()) {
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                gui.callOnClose(event);
                if (humanEntity.getOpenInventory().getTopInventory() instanceof PlayerInventory) {
                    humanEntity.closeInventory();
                }
            });
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                gui.getHumanEntityCache().restoreAndForget(humanEntity);
                if (gui.getViewerCount() == 1) {
                    this.activeGuiInstances.remove(gui);
                }
                if (gui instanceof AnvilGui) {
                    ((AnvilGui)gui).handleClose(humanEntity);
                } else if (gui instanceof MerchantGui) {
                    ((MerchantGui)gui).handleClose(humanEntity);
                } else if (gui instanceof ModernSmithingTableGui) {
                    ((ModernSmithingTableGui)gui).handleClose(humanEntity);
                }
            });
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryOpen(@NotNull InventoryOpenEvent event) {
        Gui gui = this.getGui(event.getInventory());
        if (gui == null) {
            return;
        }
        this.activeGuiInstances.add(gui);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPluginDisable(@NotNull PluginDisableEvent event) {
        if (event.getPlugin() != this.plugin) {
            return;
        }
        int counter = 0;
        int maxCount = 10;
        while (!this.activeGuiInstances.isEmpty() && counter++ < maxCount) {
            for (Gui gui : new ArrayList<Gui>(this.activeGuiInstances)) {
                for (HumanEntity viewer : gui.getViewers()) {
                    viewer.closeInventory();
                }
            }
        }
        if (counter == maxCount) {
            Logger logger = this.plugin.getLogger();
            logger.warning("Unable to close GUIs on plugin disable: they keep getting opened (tried: " + maxCount + " times)");
        }
    }

    @Nullable
    @Contract(pure=true)
    private Gui getGui(@NotNull Inventory inventory) {
        Gui gui = Gui.getGui(inventory);
        if (gui != null) {
            return gui;
        }
        InventoryHolder holder = inventory.getHolder();
        if (holder instanceof Gui) {
            return (Gui)holder;
        }
        return null;
    }
}

