/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.reflect;

import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Bukkit;

public enum Version {
    v1_8_R1(8, "1.8"),
    v1_8_R2(8, "1.8.3"),
    v1_8_R3(8, "1.8.4", "1.8.5", "1.8.6", "1.8.7", "1.8.8"),
    v1_9_R1(9, "1.9", "1.9.2"),
    v1_9_R2(9, "1.9.4"),
    v1_10_R1(10, "1.10", "1.10.2"),
    v1_11_R1(11, "1.11", "1.11.1", "1.11.2"),
    v1_12_R1(12, "1.12", "1.12.1", "1.12.2"),
    v1_13_R1(13, "1.13"),
    v1_13_R2(13, "1.13.1", "1.13.2"),
    v1_14_R1(14, "1.14", "1.14.1", "1.14.2", "1.14.3", "1.14.4"),
    v1_15_R1(15, "1.15", "1.15.1", "1.15.2"),
    v1_16_R1(16, "1.16"),
    v1_16_R2(16, "1.16.2", "1.16.3"),
    v1_16_R3(16, "1.16.4", "1.16.5"),
    v1_17_R1(17, "1.17", "1.17.1"),
    v1_18_R1(18, "1.18", "1.18.1"),
    v1_18_R2(18, "1.18.2"),
    v1_19_R1(19, "1.19", "1.19.1", "1.19.2"),
    v1_19_R2(19, "1.19.3"),
    v1_19_R3(19, "1.19.4"),
    v1_20_R1(20, "1.20", "1.20.1"),
    v1_20_R2(20, "1.20.2"),
    v1_20_R3(20, "1.20.3", "1.20.4"),
    v1_20_R4(20, "1.20.5", "1.20.6");

    public static final Version CURRENT;
    private final int minor;
    private final String[] minecraftVersions;

    private static Version getCurrentVersion() {
        String bukkitVersion = Bukkit.getServer().getBukkitVersion();
        String minecraftVersion = bukkitVersion.split("-", 2)[0];
        return Version.fromMinecraftVersion(minecraftVersion);
    }

    @Nullable
    public static Version fromString(String version) {
        if (version == null) {
            return null;
        }
        for (Version value : Version.values()) {
            if (!value.name().equalsIgnoreCase(version)) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public static Version fromMinecraftVersion(String minecraftVersion) {
        for (Version version : Version.values()) {
            for (String candidateMinecraftVersion : version.getMinecraftVersions()) {
                if (!candidateMinecraftVersion.equals(minecraftVersion)) continue;
                return version;
            }
        }
        return null;
    }

    public static boolean is(int minor) {
        return CURRENT.getMinor() == minor;
    }

    public static boolean is(@NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return CURRENT == version;
    }

    public static boolean after(int minor) {
        return CURRENT.getMinor() > minor;
    }

    public static boolean after(@NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return CURRENT.ordinal() > version.ordinal();
    }

    public static boolean afterOrEqual(int minor) {
        return CURRENT.getMinor() >= minor;
    }

    public static boolean afterOrEqual(@NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return CURRENT.ordinal() >= version.ordinal();
    }

    public static boolean before(int minor) {
        return CURRENT.getMinor() < minor;
    }

    public static boolean before(@NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return CURRENT.ordinal() < version.ordinal();
    }

    public static boolean beforeOrEqual(int minor) {
        return CURRENT.getMinor() <= minor;
    }

    public static boolean beforeOrEqual(@NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return CURRENT.ordinal() <= version.ordinal();
    }

    public static boolean supportsHex() {
        return Version.afterOrEqual(16);
    }

    private Version(int minor, String ... minecraftVersions) {
        this.minor = minor;
        this.minecraftVersions = minecraftVersions;
    }

    public int getMinor() {
        return this.minor;
    }

    public String[] getMinecraftVersions() {
        return this.minecraftVersions;
    }

    static {
        CURRENT = Version.getCurrentVersion();
    }
}

