/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.reflect;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtil {
    private static final Map<Class<?>, Map<String, Field>> FIELD_CACHE = new ConcurrentHashMap();
    private static final String CRAFTBUKKIT_PACKAGE = Bukkit.getServer().getClass().getPackage().getName();
    private static String version;

    public static <T> boolean setFieldValue(@NotNull Object object, @NotNull String fieldName, @Nullable T value) {
        Class<?> clazz = object.getClass();
        Field field = ReflectionUtil.getCachedField(clazz, fieldName);
        if (field != null) {
            try {
                field.set(object, value);
                return true;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    public static <T> T getFieldValue(@NotNull Object object, @NotNull String fieldName) {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        Field field = ReflectionUtil.getCachedField(clazz, fieldName);
        if (field != null) {
            try {
                return (T)field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static Field getCachedField(@NotNull Class<?> clazz, @NotNull String fieldName) {
        Field field;
        Map<String, Field> existingFields;
        Map<String, Field> classFields = FIELD_CACHE.get(clazz);
        if (classFields == null && (existingFields = FIELD_CACHE.putIfAbsent(clazz, classFields = new ConcurrentHashMap<String, Field>())) != null) {
            classFields = existingFields;
        }
        if ((field = classFields.get(fieldName)) == null) {
            try {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                classFields.put(fieldName, field);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return field;
    }

    public static String getVersion() {
        if (version == null) {
            version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        }
        return version;
    }

    @Nullable
    public static Class<?> getClass(@NotNull String classPath) {
        try {
            return Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Class<?> getNMClass(@NotNull String classPath) {
        try {
            return Class.forName("net.minecraft." + classPath);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Class<?> getNMSClass(@NotNull String classPath) {
        try {
            return Class.forName("net.minecraft.server." + ReflectionUtil.getVersion() + "." + classPath);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Class<?> getObcClass(@NotNull String classPath) {
        try {
            return Class.forName(CRAFTBUKKIT_PACKAGE + "." + classPath);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ReflectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

