/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.objects;

import eu.decentsoftware.holograms.api.utils.objects.BoundingBox;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Ray {
    private final Location start;
    private final Vector direction;

    public Ray(@NotNull Location start, @NotNull Vector direction) {
        this.start = start;
        this.direction = direction;
    }

    public Iterator<Location> locations(final double maxDistance, final double step) {
        return new Iterator<Location>(){
            double t = 0.0;

            @Override
            public boolean hasNext() {
                return this.t < maxDistance;
            }

            @Override
            public Location next() {
                double x = Ray.this.start.getX() + this.t * Ray.this.direction.getX();
                double y = Ray.this.start.getY() + this.t * Ray.this.direction.getY();
                double z = Ray.this.start.getZ() + this.t * Ray.this.direction.getZ();
                this.t += step;
                return new Location(Ray.this.start.getWorld(), x, y, z);
            }
        };
    }

    public boolean intersects(@NotNull BoundingBox bb, double maxDistance, double step) {
        for (double t = 0.0; t < maxDistance; t += step) {
            double z;
            double y;
            double x = this.start.getX() + t * this.direction.getX();
            if (!bb.contains(x, y = this.start.getY() + t * this.direction.getY(), z = this.start.getZ() + t * this.direction.getZ())) continue;
            return true;
        }
        return false;
    }

    public Location getStart() {
        return this.start;
    }

    public Vector getDirection() {
        return this.direction;
    }
}

