/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.items;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import lombok.NonNull;
import org.bukkit.SkullType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public final class SkullUtils {
    private static Field PROFILE_FIELD;
    private static Method SET_PROFILE_METHOD;
    private static boolean INITIALIZED;
    private static Method PROPERTY_VALUE_METHOD;
    private static Function<Property, String> VALUE_RESOLVER;

    @Nullable
    public static String getSkullTexture(@NonNull ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        try {
            PropertyMap properties;
            Collection property2;
            GameProfile profile;
            ItemMeta meta = itemStack.getItemMeta();
            if (!(meta instanceof SkullMeta)) {
                return null;
            }
            if (PROFILE_FIELD == null) {
                PROFILE_FIELD = meta.getClass().getDeclaredField("profile");
                PROFILE_FIELD.setAccessible(true);
            }
            if ((profile = (GameProfile)PROFILE_FIELD.get(meta)) == null) {
                return null;
            }
            if (VALUE_RESOLVER == null) {
                try {
                    Property.class.getMethod("getValue", new Class[0]);
                    VALUE_RESOLVER = Property::getValue;
                }
                catch (NoSuchMethodException ignored) {
                    PROPERTY_VALUE_METHOD = Property.class.getMethod("value", new Class[0]);
                    VALUE_RESOLVER = property -> {
                        try {
                            return (String)PROPERTY_VALUE_METHOD.invoke(property, new Object[0]);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            DecentHologramsAPI.get().getLogger().log(Level.SEVERE, "Failed to invoke Property#value", e);
                            return null;
                        }
                    };
                }
            }
            if ((property2 = (properties = profile.getProperties()).get((Object)"textures")) != null && !property2.isEmpty()) {
                return VALUE_RESOLVER.apply((Property)property2.iterator().next());
            }
        }
        catch (Exception e) {
            DecentHologramsAPI.get().getLogger().log(Level.SEVERE, "Unhandled exception while retrieving skull texture", e);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static String getTexture(@NonNull ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        return SkullUtils.getSkullTexture(itemStack);
    }

    public static void setSkullTexture(@NonNull ItemStack itemStack, @NonNull String texture) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        try {
            ItemMeta meta = itemStack.getItemMeta();
            if (meta instanceof SkullMeta) {
                GameProfile profile = new GameProfile(UUID.randomUUID(), "");
                Property property = new Property("textures", texture);
                PropertyMap properties = profile.getProperties();
                properties.put((Object)"textures", (Object)property);
                if (SET_PROFILE_METHOD == null && !INITIALIZED) {
                    try {
                        SET_PROFILE_METHOD = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                        SET_PROFILE_METHOD.setAccessible(true);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    INITIALIZED = true;
                }
                if (SET_PROFILE_METHOD != null) {
                    SET_PROFILE_METHOD.invoke((Object)meta, profile);
                } else {
                    if (PROFILE_FIELD == null) {
                        PROFILE_FIELD = meta.getClass().getDeclaredField("profile");
                        PROFILE_FIELD.setAccessible(true);
                    }
                    PROFILE_FIELD.set(meta, profile);
                }
            }
            itemStack.setItemMeta(meta);
            if (Version.before(13)) {
                itemStack.setDurability((short)SkullType.PLAYER.ordinal());
            }
        }
        catch (Exception e) {
            DecentHologramsAPI.get().getLogger().log(Level.SEVERE, "Unhandled exception while setting skull texture", e);
        }
    }

    @Nullable
    public static String getSkullOwner(@NonNull ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof SkullMeta) {
            return ((SkullMeta)meta).getOwner();
        }
        return null;
    }

    public static void setSkullOwner(@NonNull ItemStack itemStack, @NonNull String owner) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof SkullMeta) {
            ((SkullMeta)meta).setOwner(owner);
            itemStack.setItemMeta(meta);
            if (Version.before(13)) {
                itemStack.setDurability((short)SkullType.PLAYER.ordinal());
            }
        }
    }

    @Nullable
    public static String getTextureFromURLByPlayerName(String username) {
        String uuid = SkullUtils.getPlayerUUID(username);
        if (uuid == null) {
            return null;
        }
        String url = "https://api.minetools.eu/profile/" + uuid;
        try {
            JSONParser jsonParser = new JSONParser();
            String userData = SkullUtils.readUrl(url);
            Object parsedData = jsonParser.parse(userData);
            JSONObject jsonData = (JSONObject)parsedData;
            JSONObject decoded = (JSONObject)jsonData.get((Object)"raw");
            JSONArray textures = (JSONArray)decoded.get((Object)"properties");
            JSONObject data = (JSONObject)textures.get(0);
            return data.get((Object)"value").toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static String getPlayerUUID(String playerName) {
        try {
            String url = "https://api.minetools.eu/uuid/" + playerName;
            JSONParser jsonParser = new JSONParser();
            String userData = SkullUtils.readUrl(url);
            Object parsedData = jsonParser.parse(userData);
            JSONObject jsonData = (JSONObject)parsedData;
            if (jsonData.get((Object)"id") != null) {
                return jsonData.get((Object)"id").toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static String readUrl(String urlString) throws Exception {
        BufferedReader reader = null;
        URLConnection connection = null;
        try {
            int read;
            connection = new URL(urlString).openConnection();
            connection.setConnectTimeout(50);
            connection.setReadTimeout(50);
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder builder = new StringBuilder();
            char[] chars = new char[1024];
            while ((read = reader.read(chars)) != -1) {
                builder.append(chars, 0, read);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    private SkullUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        INITIALIZED = false;
    }
}

