/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.items;

import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.items.ItemBuilder;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class ItemWrapper {
    protected Material material;
    protected String name;
    protected String skullOwner;
    protected String skullTexture;
    protected int amount;
    protected short durability;
    protected List<String> lore;
    protected Map<Enchantment, Integer> enchantments;
    protected ItemFlag[] flags;

    public boolean canParse() {
        return this.material != null;
    }

    public ItemStack parse() {
        ItemBuilder itemBuilder = this.buildCommon();
        if (this.skullOwner != null) {
            itemBuilder.withSkullOwner(this.skullOwner);
        } else if (this.skullTexture != null) {
            itemBuilder.withSkullTexture(this.skullTexture);
        }
        itemBuilder.withItemFlags(this.flags);
        return itemBuilder.build();
    }

    public ItemStack parse(Player player) {
        return this.parseBuilder(player).build();
    }

    public ItemBuilder parseBuilder(Player player) {
        ItemBuilder itemBuilder = this.buildCommon();
        if (this.skullOwner != null) {
            itemBuilder.withSkullOwner(this.skullOwner.equals("@") ? player.getName() : this.skullOwner);
        } else if (this.skullTexture != null) {
            itemBuilder.withSkullTexture(this.skullTexture);
        }
        itemBuilder.withItemFlags(this.flags);
        return itemBuilder;
    }

    private ItemBuilder buildCommon() {
        ItemBuilder temp = new ItemBuilder(this.material == null ? Material.STONE : this.material).withAmount(this.amount).withDurability(this.durability);
        if (this.name != null) {
            temp.withName(Common.colorize(this.name));
        }
        if (this.lore != null && !this.lore.isEmpty()) {
            temp.withLore(Common.colorize(this.lore));
        }
        if (this.enchantments != null && !this.enchantments.isEmpty()) {
            this.enchantments.forEach(temp::withEnchantment);
        }
        return temp;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getName() {
        return this.name;
    }

    public String getSkullOwner() {
        return this.skullOwner;
    }

    public String getSkullTexture() {
        return this.skullTexture;
    }

    public int getAmount() {
        return this.amount;
    }

    public short getDurability() {
        return this.durability;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    public ItemFlag[] getFlags() {
        return this.flags;
    }

    public ItemWrapper(Material material, String name, String skullOwner, String skullTexture, int amount, short durability, List<String> lore, Map<Enchantment, Integer> enchantments, ItemFlag[] flags) {
        this.material = material;
        this.name = name;
        this.skullOwner = skullOwner;
        this.skullTexture = skullTexture;
        this.amount = amount;
        this.durability = durability;
        this.lore = lore;
        this.enchantments = enchantments;
        this.flags = flags;
    }
}

