/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.nms;

import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.nms.NMS;
import eu.decentsoftware.holograms.api.nms.PacketHandlerCustom;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PacketListener {
    private static final String IDENTIFIER = "DecentHolograms";
    private final DecentHolograms decentHolograms;
    private final NMS nms;

    public PacketListener(DecentHolograms decentHolograms) {
        this.decentHolograms = decentHolograms;
        this.nms = NMS.getInstance();
        this.hookAll();
    }

    public void destroy() {
        this.unhookAll();
    }

    public void hook(Player player) {
        this.executeOnPipeline(player, pipeline -> {
            if (pipeline.get(IDENTIFIER) != null) {
                pipeline.remove(IDENTIFIER);
            }
            pipeline.addBefore("packet_handler", IDENTIFIER, (ChannelHandler)new PacketHandlerCustom(player));
        });
    }

    public void unhook(Player player) {
        this.executeOnPipeline(player, pipeline -> {
            if (pipeline.get(IDENTIFIER) != null) {
                pipeline.remove(IDENTIFIER);
            }
        });
    }

    private void executeOnPipeline(Player player, Consumer<ChannelPipeline> consumer) {
        try {
            if (!player.isOnline()) {
                return;
            }
            ChannelPipeline pipeline = this.nms.getPipeline(player);
            EventLoop eventLoop = pipeline.channel().eventLoop();
            if (eventLoop.inEventLoop()) {
                consumer.accept(pipeline);
            } else {
                eventLoop.execute(() -> this.executeOnPipeline(player, consumer));
            }
        }
        catch (Exception e) {
            this.decentHolograms.getLogger().log(Level.WARNING, "Failed to modify player's pipeline. (" + player.getName() + ")", e);
        }
    }

    public void hookAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.hook(player);
        }
    }

    public void unhookAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.unhook(player);
        }
    }
}

