/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.holograms;

import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.Settings;
import eu.decentsoftware.holograms.api.actions.ClickType;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramLine;
import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.exception.LocationParseException;
import eu.decentsoftware.holograms.api.utils.file.FileUtils;
import eu.decentsoftware.holograms.api.utils.scheduler.S;
import eu.decentsoftware.holograms.api.utils.tick.Ticked;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class HologramManager
extends Ticked {
    private final DecentHolograms decentHolograms;
    private final Map<String, Hologram> hologramMap = new ConcurrentHashMap<String, Hologram>();
    private final Map<UUID, Long> clickCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Set<HologramLine> temporaryLines = ConcurrentHashMap.newKeySet();
    private final Map<String, Set<String>> toLoad = new ConcurrentHashMap<String, Set<String>>();

    public HologramManager(DecentHolograms decentHolograms) {
        super(20L);
        this.decentHolograms = decentHolograms;
        this.register();
        S.async(this::reload);
    }

    @Override
    public synchronized void tick() {
        for (Hologram hologram : Hologram.getCachedHolograms()) {
            if (!hologram.isEnabled()) continue;
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.updateVisibility(player, hologram);
            }
        }
    }

    public void updateVisibility(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        for (Hologram hologram : Hologram.getCachedHolograms()) {
            this.updateVisibility(player, hologram);
        }
    }

    public void updateVisibility(@NonNull Player player, @NonNull Hologram hologram) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (hologram == null) {
            throw new NullPointerException("hologram is marked non-null but is null");
        }
        if (hologram.isDisabled()) {
            return;
        }
        if (hologram.isHideState(player) || !hologram.isDefaultVisibleState() && !hologram.isShowState(player)) {
            if (hologram.isVisible(player)) {
                hologram.hide(player);
            }
            return;
        }
        if (!hologram.isVisible(player) && hologram.canShow(player) && hologram.isInDisplayRange(player)) {
            hologram.show(player, hologram.getPlayerPage(player));
        } else if (!(!hologram.isVisible(player) || hologram.canShow(player) && hologram.isInDisplayRange(player))) {
            hologram.hide(player);
        }
    }

    public HologramLine spawnTemporaryHologramLine(@NonNull Location location, String content, long duration) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        HologramLine line = new HologramLine(null, location, content);
        this.temporaryLines.add(line);
        line.show(new Player[0]);
        S.async(() -> {
            line.destroy();
            this.temporaryLines.remove(line);
        }, duration);
        return line;
    }

    public boolean onClick(@NonNull Player player, int entityId, @NonNull ClickType clickType) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (clickType == null) {
            throw new NullPointerException("clickType is marked non-null but is null");
        }
        UUID uid = player.getUniqueId();
        if (this.clickCooldowns.containsKey(uid) && System.currentTimeMillis() - this.clickCooldowns.get(uid) < (long)Settings.CLICK_COOLDOWN * 50L) {
            return false;
        }
        for (Hologram hologram : Hologram.getCachedHolograms()) {
            if (!hologram.isVisible(player) || !hologram.getLocation().getWorld().equals(player.getLocation().getWorld())) continue;
            double dx = hologram.getLocation().getX() - player.getLocation().getX();
            double dz = hologram.getLocation().getZ() - player.getLocation().getZ();
            if (dx > 5.0 || dx < -5.0 || dz > 5.0 || dz < -5.0 || !hologram.onClick(player, entityId, clickType)) continue;
            this.clickCooldowns.put(uid, System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public void onQuit(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        Hologram.getCachedHolograms().forEach(hologram -> hologram.onQuit(player));
        this.clickCooldowns.remove(player.getUniqueId());
    }

    public synchronized void reload() {
        this.destroy();
        this.loadHolograms();
    }

    public synchronized void destroy() {
        for (Hologram hologram : this.getHolograms()) {
            hologram.destroy();
        }
        this.hologramMap.clear();
        for (HologramLine line : this.temporaryLines) {
            line.destroy();
        }
        this.temporaryLines.clear();
        this.clickCooldowns.clear();
    }

    public void showAll(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        for (Hologram hologram : this.getHolograms()) {
            hologram.show(player, hologram.getPlayerPage(player));
        }
        for (HologramLine line : this.temporaryLines) {
            line.show(player);
        }
    }

    public void hideAll(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        for (Hologram hologram : this.getHolograms()) {
            hologram.hide(player);
        }
        for (HologramLine line : this.temporaryLines) {
            line.hide(player);
        }
    }

    public boolean containsHologram(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.hologramMap.containsKey(name);
    }

    public void registerHologram(@NonNull Hologram hologram) {
        if (hologram == null) {
            throw new NullPointerException("hologram is marked non-null but is null");
        }
        this.hologramMap.put(hologram.getName(), hologram);
    }

    public Hologram getHologram(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.hologramMap.get(name);
    }

    public Hologram removeHologram(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.hologramMap.remove(name);
    }

    public Set<String> getHologramNames() {
        return this.hologramMap.keySet();
    }

    @NonNull
    public Collection<Hologram> getHolograms() {
        return this.hologramMap.values();
    }

    @NonNull
    public Map<String, Set<String>> getToLoad() {
        return this.toLoad;
    }

    private void loadHolograms() {
        this.hologramMap.clear();
        File folder = new File(this.decentHolograms.getDataFolder(), "holograms");
        List<File> files = FileUtils.getFilesFromTree(folder, "[a-zA-Z0-9_-]+\\.yml", true);
        if (files.isEmpty()) {
            return;
        }
        int counter = 0;
        Common.log("Loading holograms... ");
        for (File file : files) {
            String filePath = FileUtils.getRelativePath(file, folder);
            try {
                Hologram hologram = Hologram.fromFile(filePath);
                if (hologram.isEnabled()) {
                    hologram.showAll();
                    hologram.realignLines();
                }
                this.registerHologram(hologram);
                ++counter;
            }
            catch (LocationParseException e) {
                String worldName = e.getWorldName();
                if (!this.toLoad.containsKey(worldName)) {
                    this.toLoad.put(worldName, new HashSet());
                }
                this.toLoad.get(worldName).add(filePath);
                ++counter;
            }
            catch (Exception e) {
                this.decentHolograms.getLogger().log(Level.WARNING, String.format("Failed to load hologram from file '%s'!", filePath), e);
            }
        }
        Common.log("Loaded %d holograms!", counter);
    }
}

