/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.actions;

import com.google.common.collect.Lists;
import eu.decentsoftware.holograms.api.actions.Action;
import java.util.List;
import lombok.NonNull;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public abstract class ActionHolder {
    protected final List<Action> actions = Lists.newArrayList();

    public void addAction(@NonNull Action action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.actions.add(action);
    }

    public void executeActions(Player player) {
        for (Action action : this.actions) {
            if (action.execute(player)) continue;
            return;
        }
    }

    public void clearActions() {
        this.actions.clear();
    }

    @Nullable
    public Action removeAction(int index) {
        return this.actions.remove(index);
    }

    @NonNull
    public List<Action> getActions() {
        return this.actions;
    }
}

